/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.upload;

import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.beans.admin.UserDetail;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import org.silverpeas.upload.UploadedFile;

public class FileUploadManager {
    private static final String UPLOADED_FILE_PREFIX_ID = "uploaded-file";

    public static Collection<UploadedFile> getUploadedFiles(HttpServletRequest request, UserDetail uploader) {
        ArrayList<UploadedFile> uploadedFiles = new ArrayList<UploadedFile>();
        if (request != null) {
            Enumeration attributeNames = request.getParameterNames();
            while (attributeNames.hasMoreElements()) {
                String attributeName = (String)attributeNames.nextElement();
                if (!attributeName.startsWith(UPLOADED_FILE_PREFIX_ID)) continue;
                uploadedFiles.add(UploadedFile.from(request, request.getParameter(attributeName), uploader));
            }
            uploadedFiles.remove(null);
            Iterator it = uploadedFiles.iterator();
            while (it.hasNext()) {
                UploadedFile uploadedFile = (UploadedFile)it.next();
                if (uploadedFile.getFile().exists()) continue;
                it.remove();
                SilverTrace.warn("upload", "FileUploadManager.getUploadedFiles", "EX_FILE_DOES_NOT_EXIST", "UploadSessionId: " + uploadedFile.getUploadSession().getId() + " - FileName: " + uploadedFile.getFile().getName());
            }
        }
        return uploadedFiles;
    }
}

