/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.upload;

import com.silverpeas.accesscontrol.AccessControllerProvider;
import com.silverpeas.session.SessionInfo;
import com.silverpeas.util.StringUtil;
import com.stratelia.webactiv.beans.admin.UserDetail;
import com.stratelia.webactiv.util.FileRepositoryManager;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.FileUtils;
import org.silverpeas.cache.service.CacheServiceFactory;
import org.silverpeas.core.admin.OrganisationControllerFactory;
import org.silverpeas.upload.UploadSessionFile;

public class UploadSession {
    static final String X_UPLOAD_SESSION = "X-UPLOAD-SESSION";
    private static final String SESSION_CACHE_KEY = "@@@_" + UploadSession.class.getName();
    private static final String UPLOAD_SESSION_CACHE_KEY_PREFIX = "@@@_instance_for_";
    private String uploadSessionId;
    private File uploadSessionFolder;
    private String componentInstanceId;
    private Map<String, String> componentInstanceParameters = new HashMap<String, String>();
    private Map<String, Boolean> currentFileWritings = new ConcurrentHashMap<String, Boolean>();

    private UploadSession(String uploadSessionId) {
        this.uploadSessionId = uploadSessionId;
    }

    public UploadSession forComponentInstanceId(String componentInstanceId) {
        this.componentInstanceId = componentInstanceId;
        return this;
    }

    public boolean isUserAuthorized(String componentInstanceId) {
        return StringUtil.isDefined(this.getComponentInstanceId()) && this.getComponentInstanceId().equals(componentInstanceId) && AccessControllerProvider.getAccessController("componentAccessController").isUserAuthorized(UserDetail.getCurrentRequester().getId(), componentInstanceId);
    }

    public String getId() {
        return this.uploadSessionId;
    }

    public String getComponentInstanceId() {
        return this.componentInstanceId;
    }

    public String getComponentInstanceParameterValue(String parameterName) {
        String parameterValue = null;
        if (StringUtil.isDefined(this.getComponentInstanceId())) {
            if (!this.componentInstanceParameters.containsKey(parameterName)) {
                parameterValue = OrganisationControllerFactory.getOrganisationController().getComponentParameterValue(this.getComponentInstanceId(), parameterName);
                this.componentInstanceParameters.put(parameterName, parameterValue);
            } else {
                parameterValue = this.componentInstanceParameters.get(parameterName);
            }
        }
        return parameterValue;
    }

    private boolean isHandledOnFileSystem() {
        return this.uploadSessionFolder != null;
    }

    public void clear() {
        if (this.isHandledOnFileSystem()) {
            FileUtils.deleteQuietly((File)this.uploadSessionFolder);
            UploadSession.removeSessionFromCache(this);
            this.uploadSessionFolder = null;
        }
    }

    public synchronized boolean remove(String fullPath) throws Exception {
        boolean removed = false;
        if (this.isHandledOnFileSystem()) {
            UploadSessionFile uploadSessionFile = this.getUploadSessionFile(fullPath);
            if (!this.currentFileWritings.containsKey(fullPath)) {
                removed = FileUtils.deleteQuietly((File)uploadSessionFile.getServerFile());
            }
        }
        return removed;
    }

    public synchronized UploadSessionFile getUploadSessionFile(String fullPath) throws Exception {
        this.initialize();
        return new UploadSessionFile(this, fullPath, new File(this.uploadSessionFolder, fullPath));
    }

    public File getRootFolder() {
        this.initialize();
        return this.uploadSessionFolder;
    }

    public File[] getRootFolderFiles() {
        File[] files = this.getRootFolder().listFiles();
        if (files == null) {
            files = new File[]{};
        }
        return files;
    }

    private synchronized void initialize() {
        if (!this.isHandledOnFileSystem()) {
            this.uploadSessionFolder = new File(FileRepositoryManager.getTemporaryPath(), this.uploadSessionId);
            if (!this.uploadSessionFolder.exists()) {
                this.uploadSessionFolder.mkdirs();
            }
        }
    }

    void markFileWritingInProgress(UploadSessionFile uploadSessionFile) throws IOException {
        String fullPath = uploadSessionFile.getFullPath();
        if (this.currentFileWritings.containsKey(fullPath)) {
            throw new IOException("An other file with the same name is currently updated (" + fullPath + ")");
        }
        this.currentFileWritings.put(fullPath, true);
    }

    void markFileWritingDone(UploadSessionFile uploadSessionFile) throws IOException {
        this.currentFileWritings.remove(uploadSessionFile.getFullPath());
    }

    public static UploadSession from(HttpServletRequest request) {
        String uploadSessionId = request.getHeader(X_UPLOAD_SESSION);
        if (StringUtil.isNotDefined(uploadSessionId)) {
            uploadSessionId = request.getParameter(X_UPLOAD_SESSION);
        }
        return UploadSession.from(uploadSessionId);
    }

    public static UploadSession from(String uploadSessionId) {
        UploadSession uploadSession = UploadSession.getSessionFromCache(uploadSessionId);
        if (uploadSession == null) {
            uploadSession = new UploadSession(UploadSession.handleUploadSessionId(uploadSessionId));
            UploadSession.registerSessionInCache(uploadSession);
        }
        return uploadSession;
    }

    private static String handleUploadSessionId(String uploadSessionIdFromRequest) {
        return StringUtil.isDefined(uploadSessionIdFromRequest) ? uploadSessionIdFromRequest : UUID.randomUUID().toString();
    }

    private static UploadSession getSessionFromCache(String uploadSessionId) {
        return CacheServiceFactory.getSessionCacheService().get(UPLOAD_SESSION_CACHE_KEY_PREFIX + uploadSessionId, UploadSession.class);
    }

    private static void registerSessionInCache(UploadSession uploadSession) {
        HashSet<String> sessionIds = CacheServiceFactory.getSessionCacheService().get(SESSION_CACHE_KEY, Set.class);
        if (sessionIds == null) {
            sessionIds = new HashSet<String>();
            CacheServiceFactory.getSessionCacheService().put(SESSION_CACHE_KEY, sessionIds);
        }
        sessionIds.add(uploadSession.uploadSessionId);
        CacheServiceFactory.getSessionCacheService().put(UPLOAD_SESSION_CACHE_KEY_PREFIX + uploadSession.getId(), uploadSession);
    }

    private static void removeSessionFromCache(UploadSession uploadSession) {
        Set sessionIds = CacheServiceFactory.getSessionCacheService().get(SESSION_CACHE_KEY, Set.class);
        if (sessionIds != null) {
            sessionIds.remove(uploadSession.getId());
            CacheServiceFactory.getSessionCacheService().remove(UPLOAD_SESSION_CACHE_KEY_PREFIX + uploadSession.getId());
        }
    }

    public static void clearFrom(SessionInfo sessionInfo) {
        Set sessionIds = sessionInfo.getCache().get(SESSION_CACHE_KEY, Set.class);
        if (sessionIds != null) {
            for (String uploadSessionId : new ArrayList(sessionIds)) {
                try {
                    UploadSession.from(uploadSessionId).clear();
                }
                catch (Exception ignore) {}
            }
            sessionInfo.getCache().remove(SESSION_CACHE_KEY);
        }
    }
}

