/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListSlice<T>
extends ArrayList<T> {
    private int start;
    private int end;
    private int maxsize = -1;

    public ListSlice(int sliceBeginIndex, int sliceEndIndex) {
        this.start = sliceBeginIndex;
        this.end = sliceEndIndex;
    }

    public ListSlice(int sliceBeginIndex, int sliceEndIndex, int originalListSize) {
        this(sliceBeginIndex, sliceEndIndex);
        this.maxsize = originalListSize;
    }

    public ListSlice(int sliceBeginIndex, int sliceEndIndex, List<? extends T> originalList) {
        super(originalList.subList(sliceBeginIndex, sliceEndIndex));
        this.start = sliceBeginIndex;
        this.end = sliceEndIndex;
        this.maxsize = originalList.size();
    }

    public ListSlice(Collection<? extends T> collection) {
        super(collection);
        this.start = 0;
        this.end = collection.size();
        this.maxsize = collection.size();
    }

    public int getBeginIndex() {
        return this.start;
    }

    public int getEndIndex() {
        return this.end;
    }

    public int getOriginalListSize() {
        return this.maxsize;
    }

    public void setOriginalListSize(int size) {
        this.maxsize = size;
    }
}

