/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class PaginationList<T>
implements List<T> {
    private final List<T> wrappedList;
    private final long maxsize;

    private PaginationList(List<T> aList) {
        this.wrappedList = aList;
        this.maxsize = this.wrappedList.size();
    }

    private PaginationList(List<T> aList, long maxItems) {
        this.wrappedList = aList;
        this.maxsize = maxItems;
    }

    public static final <T> PaginationList<T> from(Collection<T> aCollection) {
        return new PaginationList<T>(new ArrayList<T>(aCollection));
    }

    public static final <T> PaginationList<T> from(Collection<T> aCollection, long maxItems) {
        return new PaginationList<T>(new ArrayList<T>(aCollection), maxItems);
    }

    public long maxSize() {
        return this.maxsize;
    }

    @Override
    public int size() {
        return this.wrappedList.size();
    }

    @Override
    public boolean isEmpty() {
        return this.wrappedList.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.wrappedList.contains(o);
    }

    @Override
    public Iterator<T> iterator() {
        return this.wrappedList.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.wrappedList.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a2) {
        return this.wrappedList.toArray(a2);
    }

    @Override
    public boolean add(T e) {
        if ((long)(this.wrappedList.size() + 1) > this.maxSize()) {
            throw new IllegalArgumentException("No more than maxsize items can be added to this pagination");
        }
        return this.wrappedList.add(e);
    }

    @Override
    public boolean remove(Object o) {
        return this.wrappedList.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.wrappedList.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        if ((long)(this.wrappedList.size() + c.size()) > this.maxSize()) {
            throw new IllegalArgumentException("No more than maxsize items can be added to this pagination");
        }
        return this.wrappedList.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        if ((long)(this.wrappedList.size() + c.size()) > this.maxSize()) {
            throw new IllegalArgumentException("No more than maxsize items can be added to this pagination");
        }
        return this.wrappedList.addAll(index, c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.wrappedList.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.wrappedList.retainAll(c);
    }

    @Override
    public void clear() {
        this.wrappedList.clear();
    }

    @Override
    public boolean equals(Object o) {
        return ((Object)this.wrappedList).equals(o);
    }

    @Override
    public int hashCode() {
        return ((Object)this.wrappedList).hashCode();
    }

    @Override
    public T get(int index) {
        return this.wrappedList.get(index);
    }

    @Override
    public T set(int index, T element) {
        return this.wrappedList.set(index, element);
    }

    @Override
    public void add(int index, T element) {
        if ((long)(this.wrappedList.size() + 1) > this.maxSize()) {
            throw new IllegalArgumentException("No more than maxsize items can be added to this pagination");
        }
        this.wrappedList.add(index, element);
    }

    @Override
    public T remove(int index) {
        return this.wrappedList.remove(index);
    }

    @Override
    public int indexOf(Object o) {
        return this.wrappedList.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.wrappedList.lastIndexOf(o);
    }

    @Override
    public ListIterator<T> listIterator() {
        return new PaginationListIterator<T>(this, this.wrappedList.listIterator());
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        return new PaginationListIterator<T>(this, this.wrappedList.listIterator(index));
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        return this.wrappedList.subList(fromIndex, toIndex);
    }

    private static class PaginationListIterator<T>
    implements ListIterator<T> {
        private final ListIterator<T> iterator;
        private final PaginationList<T> list;

        public PaginationListIterator(PaginationList<T> list, ListIterator<T> iterator) {
            this.iterator = iterator;
            this.list = list;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public T next() {
            return this.iterator.next();
        }

        @Override
        public boolean hasPrevious() {
            return this.iterator.hasPrevious();
        }

        @Override
        public T previous() {
            return this.iterator.previous();
        }

        @Override
        public int nextIndex() {
            return this.iterator.nextIndex();
        }

        @Override
        public int previousIndex() {
            return this.iterator.previousIndex();
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }

        @Override
        public void set(T e) {
            this.iterator.set(e);
        }

        @Override
        public void add(T e) {
            if (this.list.maxSize() + 1L > 0L) {
                throw new IllegalArgumentException("No more than maxsize items can be added to this pagination");
            }
            this.iterator.add(e);
        }
    }
}

