/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.util.crypto;

import java.io.FileInputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.UnrecoverableEntryException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.silverpeas.util.crypto.CryptoException;

public class PKS12KeyStore {
    private X509Certificate cert = null;
    private PrivateKey privatekey = null;
    private PublicKey publickey = null;
    private static final String LOAD_FAILURE = "The load of the public and secret keys, and of the X509 certificate failed!";

    public PKS12KeyStore(String p12FilePath, String password) throws KeyStoreException, CryptoException {
        KeyStore ks = null;
        Security.addProvider((Provider)new BouncyCastleProvider());
        ks = KeyStore.getInstance("PKCS12");
        if (p12FilePath != null) {
            try {
                ks.load(new FileInputStream(p12FilePath), password.toCharArray());
            }
            catch (Exception ex) {
                throw new CryptoException(LOAD_FAILURE, ex);
            }
        }
        try {
            String[] aliases;
            Enumeration<String> en = ks.aliases();
            String alias = "";
            ArrayList<String> vectaliases = new ArrayList<String>();
            while (en.hasMoreElements()) {
                vectaliases.add(en.nextElement());
            }
            for (String aliase : aliases = vectaliases.toArray(new String[vectaliases.size()])) {
                if (!ks.isKeyEntry(aliase)) continue;
                alias = aliase;
                break;
            }
            this.privatekey = (PrivateKey)ks.getKey(alias, password.toCharArray());
            this.cert = (X509Certificate)ks.getCertificate(alias);
            this.publickey = ks.getCertificate(alias).getPublicKey();
        }
        catch (NoSuchAlgorithmException ex) {
            throw new CryptoException(LOAD_FAILURE, ex);
        }
        catch (UnrecoverableEntryException ex) {
            throw new CryptoException(LOAD_FAILURE, ex);
        }
    }

    public X509Certificate getCertificate() {
        return this.cert;
    }

    public PrivateKey getPrivatekey() {
        return this.privatekey;
    }

    public PublicKey getPublickey() {
        return this.publickey;
    }
}

