/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.util.data;

import com.silverpeas.scheduler.Job;
import com.silverpeas.scheduler.JobExecutionContext;
import com.silverpeas.scheduler.Scheduler;
import com.silverpeas.scheduler.trigger.JobTrigger;
import com.silverpeas.util.StringUtil;
import com.stratelia.webactiv.util.FileRepositoryManager;
import java.io.File;
import java.util.Collection;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.AbstractFileFilter;
import org.apache.commons.io.filefilter.AgeFileFilter;
import org.apache.commons.io.filefilter.AndFileFilter;
import org.apache.commons.io.filefilter.FalseFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.silverpeas.util.data.TemporaryDataManagementSettings;

@Named(value="temporaryDataCleanerSchedulerInitializer")
public class TemporaryDataCleanerSchedulerInitializer {
    public static final String JOB_NAME = "TemporayDataCleanerJob";
    private static final File tempPath = new File(FileRepositoryManager.getTemporaryPath());
    @Inject
    private Scheduler scheduler;
    Thread startTask;

    @PostConstruct
    public void initialize() throws Exception {
        final TemporaryDataCleanerJob temporaryDataCleanerJob = new TemporaryDataCleanerJob();
        this.startTask = new Thread(new Runnable(){

            @Override
            public void run() {
                temporaryDataCleanerJob.clean(TemporaryDataManagementSettings.getTimeAfterThatFilesMustBeDeletedAtServerStart());
            }
        });
        this.startTask.start();
        String cron = TemporaryDataManagementSettings.getJobCron();
        if (StringUtil.isDefined(cron)) {
            this.scheduler.scheduleJob(temporaryDataCleanerJob, JobTrigger.triggerAt(cron));
        }
    }

    private class TemporaryDataCleanerJob
    extends Job {
        public TemporaryDataCleanerJob() {
            super(TemporaryDataCleanerSchedulerInitializer.JOB_NAME);
        }

        @Override
        public void execute(JobExecutionContext context) throws Exception {
            long nbMilliseconds = TemporaryDataManagementSettings.getTimeAfterThatFilesMustBeDeleted();
            if (nbMilliseconds < 0L) {
                nbMilliseconds = 0L;
            }
            this.clean(nbMilliseconds);
        }

        private synchronized void clean(long nbMilliseconds) {
            if (tempPath.exists() && nbMilliseconds >= 0L) {
                long fileAge = System.currentTimeMillis() - nbMilliseconds;
                this.delete(FileUtils.listFiles((File)tempPath, (IOFileFilter)new AgeFileFilter(fileAge), (IOFileFilter)TrueFileFilter.TRUE));
                fileAge = System.currentTimeMillis() - nbMilliseconds;
                this.delete(FileUtils.listFilesAndDirs((File)tempPath, (IOFileFilter)FalseFileFilter.FALSE, (IOFileFilter)new AndFileFilter((IOFileFilter)new AgeFileFilter(fileAge), (IOFileFilter)new AbstractFileFilter(){

                    public boolean accept(File file, String name) {
                        return FileUtils.listFiles((File)file, (IOFileFilter)TrueFileFilter.TRUE, (IOFileFilter)TrueFileFilter.TRUE).size() == 0;
                    }
                })));
            }
        }

        private void delete(Collection<File> filesToDelete) {
            if (filesToDelete != null) {
                filesToDelete.remove(tempPath);
                for (File fileToDelete : filesToDelete) {
                    FileUtils.deleteQuietly((File)fileToDelete);
                }
            }
        }
    }
}

