/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.util.jcr;

import com.silverpeas.jcrutil.converter.ConverterUtil;
import com.silverpeas.util.ArrayUtil;
import com.silverpeas.util.CollectionUtil;
import com.silverpeas.util.FileUtil;
import com.stratelia.webactiv.util.DBUtil;
import com.stratelia.webactiv.util.exception.UtilException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.jcr.AccessDeniedException;
import javax.jcr.Binary;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NodeType;
import javax.jcr.version.VersionException;
import org.apache.commons.io.IOUtils;

public abstract class AbstractJcrConverter {
    protected String getStringProperty(Node node, String propertyName) throws ValueFormatException, RepositoryException {
        if (node.hasProperty(propertyName)) {
            return node.getProperty(propertyName).getString();
        }
        return null;
    }

    protected String getComponentId(Node node) throws ItemNotFoundException, AccessDeniedException, RepositoryException {
        return ConverterUtil.convertFromJcrPath(node.getAncestor(1).getName());
    }

    public void addStringProperty(Node node, String propertyName, String value) throws VersionException, LockException, ConstraintViolationException, RepositoryException {
        if (value == null) {
            try {
                node.getProperty(propertyName).remove();
            }
            catch (PathNotFoundException pnfex) {}
        } else {
            node.setProperty(propertyName, value);
        }
    }

    public void addDateProperty(Node node, String propertyName, Date value) throws VersionException, LockException, ConstraintViolationException, RepositoryException {
        if (value == null) {
            try {
                node.getProperty(propertyName).remove();
            }
            catch (PathNotFoundException pnfex) {}
        } else {
            Calendar calend = Calendar.getInstance();
            calend.setTime(value);
            Value propertyValue = node.getSession().getValueFactory().createValue(calend);
            node.setProperty(propertyName, propertyValue);
        }
    }

    public void addCalendarProperty(Node node, String propertyName, Calendar value) throws VersionException, LockException, ConstraintViolationException, RepositoryException {
        if (value == null) {
            try {
                node.getProperty(propertyName).remove();
            }
            catch (PathNotFoundException pnfex) {}
        } else {
            Value propertyValue = node.getSession().getValueFactory().createValue(value);
            node.setProperty(propertyName, propertyValue);
        }
    }

    protected Calendar getCalendarProperty(Node node, String propertyName) throws ValueFormatException, RepositoryException {
        if (node.hasProperty(propertyName)) {
            return node.getProperty(propertyName).getDate();
        }
        return null;
    }

    protected Date getDateProperty(Node node, String propertyName) throws ValueFormatException, RepositoryException {
        if (node.hasProperty(propertyName)) {
            return node.getProperty(propertyName).getDate().getTime();
        }
        return null;
    }

    protected int getIntProperty(Node node, String propertyName) throws ValueFormatException, RepositoryException {
        if (node.hasProperty(propertyName)) {
            return Long.valueOf(node.getProperty(propertyName).getLong()).intValue();
        }
        return 0;
    }

    protected boolean getBooleanProperty(Node node, String propertyName) throws ValueFormatException, RepositoryException {
        if (node.hasProperty(propertyName)) {
            return node.getProperty(propertyName).getBoolean();
        }
        return false;
    }

    protected long getLongProperty(Node node, String propertyName) throws ValueFormatException, RepositoryException {
        if (node.hasProperty(propertyName)) {
            return node.getProperty(propertyName).getLong();
        }
        return 0L;
    }

    protected Value[] removeReference(Value[] values, String uuid) throws ValueFormatException, IllegalStateException, RepositoryException {
        List<Value> references = CollectionUtil.asList(values);
        Iterator<Value> iter = references.iterator();
        while (iter.hasNext()) {
            Value value = iter.next();
            if (!uuid.equals(value.getString())) continue;
            iter.remove();
            return references.toArray(new Value[values.length - 1]);
        }
        return values;
    }

    protected String computeUniqueName(String prefix, String tableName) throws UtilException {
        return prefix + DBUtil.getNextId(tableName, null);
    }

    public void setContent(Node fileNode, InputStream content, String mimeType) throws RepositoryException {
        Node contentNode = fileNode.hasNode("{http://www.jcp.org/jcr/1.0}content") ? fileNode.getNode("{http://www.jcp.org/jcr/1.0}content") : fileNode.addNode("{http://www.jcp.org/jcr/1.0}content", "nt:resource");
        Binary binaryContent = fileNode.getSession().getValueFactory().createBinary(content);
        contentNode.setProperty("{http://www.jcp.org/jcr/1.0}data", binaryContent);
        binaryContent.dispose();
        String fileMimeType = mimeType;
        if (fileMimeType == null) {
            fileMimeType = FileUtil.getMimeType(fileNode.getProperty("slv:name").getString());
        }
        contentNode.setProperty("{http://www.jcp.org/jcr/1.0}encoding", "UTF-8");
        contentNode.setProperty("{http://www.jcp.org/jcr/1.0}mimeType", fileMimeType);
        Calendar lastModified = Calendar.getInstance();
        contentNode.setProperty("{http://www.jcp.org/jcr/1.0}lastModified", lastModified);
    }

    public String getContentMimeType(Node fileNode) throws RepositoryException {
        if (fileNode.hasNode("{http://www.jcp.org/jcr/1.0}content")) {
            Node contentNode = fileNode.getNode("{http://www.jcp.org/jcr/1.0}content");
            return this.getStringProperty(contentNode, "{http://www.jcp.org/jcr/1.0}mimeType");
        }
        return null;
    }

    public long getContentSize(Node fileNode) throws RepositoryException {
        if (fileNode.hasNode("{http://www.jcp.org/jcr/1.0}content")) {
            Node contentNode = fileNode.getNode("{http://www.jcp.org/jcr/1.0}content");
            return this.getSize(contentNode);
        }
        return 0L;
    }

    public void setContent(Node fileNode, File file, String mimeType) throws RepositoryException {
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            this.setContent(fileNode, in, mimeType);
        }
        catch (FileNotFoundException ex) {
            try {
                throw new RepositoryException((Throwable)ex);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setContent(Node fileNode, byte[] content, String mimeType) throws RepositoryException {
        ByteArrayInputStream in = new ByteArrayInputStream(content);
        try {
            this.setContent(fileNode, in, mimeType);
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
    }

    public byte[] getContent(Node fileNode) throws RepositoryException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        if (fileNode.hasNode("{http://www.jcp.org/jcr/1.0}content")) {
            Node contentNode = fileNode.getNode("{http://www.jcp.org/jcr/1.0}content");
            InputStream in = contentNode.getProperty("{http://www.jcp.org/jcr/1.0}data").getBinary().getStream();
            try {
                IOUtils.copy((InputStream)in, (OutputStream)out);
            }
            catch (IOException ioex) {
                throw new RepositoryException((Throwable)ioex);
            }
            finally {
                IOUtils.closeQuietly((InputStream)in);
                IOUtils.closeQuietly((OutputStream)out);
            }
            return out.toByteArray();
        }
        return ArrayUtil.EMPTY_BYTE_ARRAY;
    }

    public Binary getBinaryContent(Node fileNode) throws RepositoryException {
        Node contentNode;
        if (fileNode.hasNode("{http://www.jcp.org/jcr/1.0}content") && (contentNode = fileNode.getNode("{http://www.jcp.org/jcr/1.0}content")).hasProperty("{http://www.jcp.org/jcr/1.0}data")) {
            return contentNode.getProperty("{http://www.jcp.org/jcr/1.0}data").getBinary();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getContent(Node fileNode, OutputStream out) throws RepositoryException, IOException {
        if (fileNode.hasNode("{http://www.jcp.org/jcr/1.0}content")) {
            Node contentNode = fileNode.getNode("{http://www.jcp.org/jcr/1.0}content");
            Binary content = contentNode.getProperty("{http://www.jcp.org/jcr/1.0}data").getBinary();
            InputStream in = content.getStream();
            try {
                IOUtils.copy((InputStream)in, (OutputStream)out);
            }
            finally {
                IOUtils.closeQuietly((InputStream)in);
                content.dispose();
            }
        }
    }

    private long getSize(Node contentNode) throws ValueFormatException, PathNotFoundException, RepositoryException {
        if (contentNode.hasProperty("{http://www.jcp.org/jcr/1.0}data")) {
            return contentNode.getProperty("{http://www.jcp.org/jcr/1.0}data").getBinary().getSize();
        }
        return 0L;
    }

    public Node getFolder(Node parent, String name) throws RepositoryException {
        if (parent.hasNode(name)) {
            return parent.getNode(name);
        }
        return parent.addNode(name, "nt:folder");
    }

    public boolean isMixinApplied(Node node, String mixin) throws RepositoryException {
        for (NodeType type : node.getMixinNodeTypes()) {
            if (!type.isNodeType(mixin)) continue;
            return true;
        }
        return false;
    }
}

