/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.util.mail;

import com.silverpeas.util.EncodeHelper;
import com.silverpeas.util.StringUtil;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.util.FileRepositoryManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.Session;
import javax.mail.internet.ContentType;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeUtility;
import javax.mail.internet.ParseException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.text.translate.CharSequenceTranslator;
import org.apache.commons.lang3.text.translate.EntityArrays;
import org.apache.commons.lang3.text.translate.LookupTranslator;
import org.silverpeas.util.mail.ExtractorException;
import org.silverpeas.util.mail.Mail;
import org.silverpeas.util.mail.MailAttachment;
import org.silverpeas.util.mail.MailExtractor;

public class EMLExtractor
implements MailExtractor {
    public static final CharSequenceTranslator ESCAPE_ISO8859_1 = new LookupTranslator((CharSequence[][])EntityArrays.ISO8859_1_ESCAPE());
    private MimeMessage message;

    public EMLExtractor(File file) throws ExtractorException {
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            this.init(in);
        }
        catch (Exception e) {
            try {
                throw new ExtractorException("EMLExtractor.constructor", 4, "", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)in);
    }

    public EMLExtractor(InputStream file) throws ExtractorException {
        try {
            this.init(file);
        }
        catch (MessagingException e) {
            throw new ExtractorException("EMLExtractor.constructor", 4, "", (Exception)((Object)e));
        }
    }

    private void init(InputStream file) throws MessagingException {
        Properties props = System.getProperties();
        Session mailSession = Session.getDefaultInstance((Properties)props, null);
        mailSession.setDebug(true);
        this.message = new MimeMessage(mailSession, file);
    }

    @Override
    public Mail getMail() throws Exception {
        Mail mail = new Mail();
        mail.setDate(this.message.getSentDate());
        mail.setSubject(this.message.getSubject());
        String body = null;
        Object messageContent = this.message.getContent();
        if (messageContent instanceof Multipart) {
            body = this.getBody((Multipart)messageContent);
        } else if (messageContent instanceof String) {
            body = (String)messageContent;
        }
        if (this.message.getFrom() != null) {
            mail.setFrom((InternetAddress)this.message.getFrom()[0]);
        }
        mail.setTo(this.message.getRecipients(Message.RecipientType.TO));
        mail.setCc(this.message.getRecipients(Message.RecipientType.CC));
        mail.setBody(ESCAPE_ISO8859_1.translate((CharSequence)body));
        return mail;
    }

    @Override
    public List<MailAttachment> getAttachments() throws Exception {
        ArrayList<MailAttachment> attachments = new ArrayList<MailAttachment>();
        Object messageContent = this.message.getContent();
        if (messageContent instanceof Multipart) {
            this.processMultipart((Multipart)messageContent, attachments);
        }
        return attachments;
    }

    private String getBody(Multipart multipart) throws MessagingException, IOException {
        int partsNumber = multipart.getCount();
        String body = "";
        for (int i = 0; i < partsNumber; ++i) {
            BodyPart part = multipart.getBodyPart(i);
            if (part.isMimeType("text/html")) {
                return (String)part.getContent();
            }
            if (part.isMimeType("text/plain")) {
                body = EncodeHelper.javaStringToHtmlParagraphe((String)part.getContent());
                continue;
            }
            if (!(part.getContent() instanceof Multipart)) continue;
            return this.getBody((Multipart)part.getContent());
        }
        return body;
    }

    private String processMultipart(Multipart multipart, List<MailAttachment> attachments) throws MessagingException, IOException {
        int partsNumber = multipart.getCount();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < partsNumber; ++i) {
            BodyPart part = multipart.getBodyPart(i);
            sb.append(this.processMailPart((Part)part, attachments));
        }
        return sb.toString();
    }

    private String processMailPart(Part part, List<MailAttachment> attachments) throws MessagingException, IOException {
        if (!this.isTextPart(part)) {
            String fileName;
            Object content = part.getContent();
            if (content instanceof Multipart) {
                Multipart mContent = (Multipart)content;
                return this.processMultipart(mContent, attachments);
            }
            if (attachments != null && (fileName = EMLExtractor.getFileName(part)) != null) {
                MailAttachment attachment = new MailAttachment(fileName);
                String dir = FileRepositoryManager.getTemporaryPath() + "mail" + System.currentTimeMillis();
                File file = new File(dir, fileName);
                FileUtils.copyInputStreamToFile((InputStream)part.getInputStream(), (File)file);
                attachment.setPath(file.getAbsolutePath());
                attachment.setSize(file.length());
                attachments.add(attachment);
            }
        } else {
            if (part.getContentType().indexOf("text/html") >= 0) {
                return (String)part.getContent();
            }
            if (part.getContentType().indexOf("text/plain") >= 0) {
                return EncodeHelper.javaStringToHtmlParagraphe((String)part.getContent());
            }
        }
        return "";
    }

    private boolean isTextPart(Part part) throws MessagingException {
        String disposition = part.getDisposition();
        if (!"attachment".equals(disposition) && !"inline".equals(disposition)) {
            try {
                ContentType type = new ContentType(part.getContentType());
                return "text".equalsIgnoreCase(type.getPrimaryType());
            }
            catch (ParseException e) {
                SilverTrace.error("util", EMLExtractor.class.getSimpleName() + ".getFileName", "root.EX_NO_MESSAGE", e);
            }
        } else if ("inline".equals(disposition)) {
            try {
                ContentType type = new ContentType(part.getContentType());
                return "text".equalsIgnoreCase(type.getPrimaryType()) && EMLExtractor.getFileName(part) == null;
            }
            catch (ParseException e) {
                SilverTrace.error("util", EMLExtractor.class.getSimpleName() + ".getFileName", "root.EX_NO_MESSAGE", e);
            }
        }
        return false;
    }

    private static String getFileName(Part part) throws MessagingException {
        String fileName = part.getFileName();
        if (!StringUtil.isDefined(fileName)) {
            try {
                ContentType type = new ContentType(part.getContentType());
                fileName = type.getParameter("name");
            }
            catch (ParseException e) {
                SilverTrace.error("util", EMLExtractor.class.getSimpleName() + ".getFileName", "root.EX_NO_MESSAGE", e);
            }
        }
        if (StringUtil.isDefined(fileName) && fileName.startsWith("=?") && fileName.endsWith("?=")) {
            try {
                fileName = MimeUtility.decodeText((String)part.getFileName());
            }
            catch (UnsupportedEncodingException e) {
                SilverTrace.error("util", EMLExtractor.class.getSimpleName() + ".getFileName", "root.EX_NO_MESSAGE", e);
            }
        }
        return fileName;
    }
}

