/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.viewer;

import com.silverpeas.annotation.Service;
import com.silverpeas.converter.DocumentFormat;
import com.silverpeas.converter.DocumentFormatConverterFactory;
import com.silverpeas.converter.option.PageRangeFilterOption;
import com.silverpeas.util.FileUtil;
import java.io.File;
import java.util.HashSet;
import java.util.Set;
import javax.inject.Inject;
import org.apache.commons.io.FileUtils;
import org.silverpeas.image.ImageTool;
import org.silverpeas.image.ImageToolDirective;
import org.silverpeas.image.option.DimensionOption;
import org.silverpeas.viewer.AbstractViewerService;
import org.silverpeas.viewer.Preview;
import org.silverpeas.viewer.PreviewService;
import org.silverpeas.viewer.TemporaryPreview;
import org.silverpeas.viewer.ViewService;
import org.silverpeas.viewer.ViewerContext;
import org.silverpeas.viewer.ViewerSettings;
import org.silverpeas.viewer.exception.ViewerException;
import org.silverpeas.viewer.util.SwfUtil;

@Service
public class DefaultPreviewService
extends AbstractViewerService
implements PreviewService {
    private static final String PROCESS_NAME = "PREVIEW";
    @Inject
    private ViewService viewService;
    private static final Set<String> imageMimeTypePreviewable = new HashSet<String>();
    @Inject
    private ImageTool imageTool;

    @Override
    public boolean isPreviewable(File file) {
        String fileName = file.getPath();
        if (this.imageTool.isActivated() && file.exists()) {
            String mimeType = FileUtil.getMimeType(fileName);
            return imageMimeTypePreviewable.contains(mimeType) || FileUtil.isPdf(fileName) || FileUtil.isOpenOfficeCompatible(fileName) || "text/plain".equals(mimeType);
        }
        return false;
    }

    @Override
    public Preview getPreview(final ViewerContext viewerContext) {
        return this.process(PROCESS_NAME, new AbstractViewerService.ViewerTreatment<Preview>(){

            @Override
            public Preview execute() {
                File resultFile;
                if (!DefaultPreviewService.this.isPreviewable(viewerContext.getOriginalSourceFile())) {
                    throw new ViewerException("IT IS NOT POSSIBLE GETTING DOCUMENT PREVIEW");
                }
                if (FileUtil.isOpenOfficeCompatible(viewerContext.getOriginalSourceFile().getName())) {
                    File pdfFile = DefaultPreviewService.this.toPdf(viewerContext.getOriginalSourceFile(), DefaultPreviewService.this.generateTmpFile(viewerContext, "pdf"));
                    resultFile = DefaultPreviewService.this.toImage(pdfFile, DefaultPreviewService.this.changeFileExtension(pdfFile, "png"));
                    FileUtils.deleteQuietly((File)pdfFile);
                } else {
                    resultFile = FileUtil.isPdf(viewerContext.getOriginalFileName()) || "text/plain".equals(FileUtil.getMimeType(viewerContext.getOriginalSourceFile().getPath())) ? DefaultPreviewService.this.toImage(viewerContext.getOriginalSourceFile(), DefaultPreviewService.this.generateTmpFile(viewerContext, "png")) : DefaultPreviewService.this.toImage(viewerContext.getOriginalSourceFile(), DefaultPreviewService.this.generateTmpFile(viewerContext, "jpg"));
                }
                return new TemporaryPreview(viewerContext.getOriginalFileName(), resultFile);
            }

            @Override
            public Preview performAfterSuccess(Preview result) {
                if (ViewerSettings.isSilentConversionEnabled() && viewerContext.isProcessingCache() && DefaultPreviewService.this.viewService.isViewable(viewerContext.getOriginalSourceFile())) {
                    Thread thread = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            DefaultPreviewService.this.viewService.getDocumentView(viewerContext.clone());
                        }
                    });
                    thread.start();
                }
                return super.performAfterSuccess(result);
            }
        }).execute(viewerContext);
    }

    private File toPdf(File source, File destination) {
        DocumentFormatConverterFactory.getFactory().getToPDFConverter().convert(source, destination, DocumentFormat.pdf, new PageRangeFilterOption("1"));
        return destination;
    }

    private File toImage(File source, File destination) {
        boolean deleteSource = false;
        if (SwfUtil.isPdfToImageActivated() && FileUtil.isPdf(source.getPath())) {
            SwfUtil.fromPdfToImage(source, destination);
            source = destination;
            destination = this.changeFileExtension(destination, "jpg");
            deleteSource = !source.equals(destination);
        }
        this.imageTool.convert(source, destination, DimensionOption.widthAndHeight(ViewerSettings.getPreviewMaxWidth(), ViewerSettings.getPreviewMaxHeight()), ImageToolDirective.PREVIEW_WORK, ImageToolDirective.GEOMETRY_SHRINK, ImageToolDirective.FIRST_PAGE_ONLY);
        if (deleteSource) {
            FileUtils.deleteQuietly((File)source);
        }
        return destination;
    }

    static {
        for (String imageExtension : new String[]{"bmp", "gif", "jpg", "pcd", "png", "tga", "tif"}) {
            imageMimeTypePreviewable.add(FileUtil.getMimeType("file." + imageExtension));
        }
        imageMimeTypePreviewable.remove("application/octet-stream");
    }
}

