/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.viewer;

import com.silverpeas.util.StringUtil;
import java.io.File;
import org.silverpeas.attachment.model.SimpleDocument;
import org.silverpeas.util.data.TemporaryWorkspaceTranslation;
import org.silverpeas.viewer.ViewerSettings;

public class ViewerContext
implements Cloneable {
    private final String originalFileName;
    private final File originalSourceFile;
    private String initializerProcessName;
    private String uniqueDocumentId = String.valueOf(System.nanoTime());
    private boolean cacheRequired = false;
    private boolean processingCache = false;

    public static ViewerContext from(SimpleDocument document) {
        return new ViewerContext(document.getFilename(), new File(document.getAttachmentPath())).withUniqueDocumentId(document.getLanguage() + "-" + document.getId());
    }

    protected ViewerContext(String originalFileName, File originalSourceFile) {
        this.originalFileName = originalFileName;
        this.originalSourceFile = originalSourceFile;
    }

    public String getOriginalFileName() {
        return this.originalFileName;
    }

    public File getOriginalSourceFile() {
        return this.originalSourceFile;
    }

    ViewerContext fromInitializerProcessName(String initializerProcessName) {
        this.initializerProcessName = initializerProcessName;
        return this;
    }

    public TemporaryWorkspaceTranslation getWorkspace() {
        return TemporaryWorkspaceTranslation.from(this.getViewId());
    }

    public String getViewId() {
        return this.initializerProcessName + "-" + this.uniqueDocumentId;
    }

    public ViewerContext withUniqueDocumentId(String uniqueDocumentId) {
        if (ViewerSettings.isCacheEnabled() && StringUtil.isDefined(uniqueDocumentId)) {
            this.uniqueDocumentId = uniqueDocumentId;
            this.cacheRequired = true;
        }
        return this;
    }

    public boolean isCacheRequired() {
        return this.cacheRequired;
    }

    public boolean isProcessingCache() {
        return this.processingCache;
    }

    public void processingCache() {
        this.processingCache = true;
    }

    protected ViewerContext clone() {
        try {
            ViewerContext clonedViewerContext = (ViewerContext)super.clone();
            clonedViewerContext.initializerProcessName = "";
            clonedViewerContext.processingCache = false;
            return clonedViewerContext;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }
}

