/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.viewer;

import java.io.File;
import javax.inject.Inject;
import org.silverpeas.viewer.PreviewService;
import org.silverpeas.viewer.ViewService;

public class ViewerFactory {
    private static ViewerFactory instance = new ViewerFactory();
    @Inject
    private PreviewService previewService;
    @Inject
    private ViewService viewService;

    private ViewerFactory() {
    }

    private static ViewerFactory getInstance() {
        return instance;
    }

    public static PreviewService getPreviewService() {
        return ViewerFactory.instance.previewService;
    }

    public static boolean isPreviewable(File file) {
        return ViewerFactory.getPreviewService().isPreviewable(file);
    }

    public static boolean isPreviewable(String path) {
        return ViewerFactory.getPreviewService().isPreviewable(new File(path));
    }

    public static boolean isViewable(File file) {
        return ViewerFactory.getViewService().isViewable(file);
    }

    public static boolean isViewable(String path) {
        return ViewerFactory.getViewService().isViewable(new File(path));
    }

    public static ViewService getViewService() {
        return ViewerFactory.instance.viewService;
    }
}

