/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.viewer.util;

import java.io.File;
import java.util.HashMap;
import org.apache.commons.exec.CommandLine;
import org.silverpeas.exec.ExternalExecution;
import org.silverpeas.exec.ExternalExecutionException;
import org.silverpeas.viewer.JsonPdfToolManager;
import org.silverpeas.viewer.exception.ViewerException;

public class JsonPdfUtil
extends ExternalExecution {
    public static final String JSON_DOCUMENT_EXTENSION = "js";
    private static final String PDF_TO_JSON_COMMON_PARAMS = "-enc UTF-8 -compress -split 10";

    public static boolean isActivated() {
        return JsonPdfToolManager.isActivated();
    }

    public static void convert(File pdfFile, File destination) {
        File out = new File(destination.getParentFile(), destination.getName() + "_%." + JSON_DOCUMENT_EXTENSION);
        try {
            if (JsonPdfUtil.exec(JsonPdfUtil.buildJsonPdfCommandLine(pdfFile, out)).isEmpty()) {
                throw new ViewerException("pdf2json conversion failed...");
            }
        }
        catch (ExternalExecutionException e) {
            throw new ViewerException(e);
        }
    }

    static CommandLine buildJsonPdfCommandLine(File inputFile, File outputFile) {
        HashMap<String, File> files = new HashMap<String, File>(2);
        files.put("inputFile", inputFile);
        files.put("outputFile", outputFile);
        CommandLine commandLine = new CommandLine("pdf2json");
        commandLine.addArgument("${inputFile}", false);
        commandLine.addArguments(PDF_TO_JSON_COMMON_PARAMS, false);
        commandLine.addArgument("${outputFile}", false);
        commandLine.setSubstitutionMap(files);
        return commandLine;
    }
}

