/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.wysiwyg.control.result;

import com.stratelia.silverpeas.peasCore.URLManager;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.activation.URLDataSource;
import javax.mail.BodyPart;
import javax.mail.Multipart;
import javax.mail.internet.MimeBodyPart;
import org.silverpeas.file.SilverpeasFile;
import org.silverpeas.file.SilverpeasFileProvider;
import org.silverpeas.util.StringDataExtractor;
import org.silverpeas.wysiwyg.control.WysiwygContentTransformerProcess;

public class MailContentProcess
implements WysiwygContentTransformerProcess<MailResult> {
    private static List<Pattern> CKEDITOR_LINK_PATTERNS = Arrays.asList(Pattern.compile("(?i)=\"([^\"]*/wysiwyg/jsp/ckeditor/[^\"]+)"));
    private static List<Pattern> ATTACHMENT_LINK_PATTERNS = Arrays.asList(Pattern.compile("(?i)=\"([^\"]*/attachmentId/[a-z\\-0-9]+/[^\"]+)"), Pattern.compile("(?i)=\"([^\"]*/File/[a-z\\-0-9]+[^\"]*)"));
    private static List<Pattern> GALLERY_CONTENT_LINK_PATTERNS = Arrays.asList(Pattern.compile("(?i)=\"([^\"]*/GalleryInWysiwyg/[^\"]+)"));

    @Override
    public MailResult execute(String wysiwygContent) throws Exception {
        String transformedWysiwygContent = wysiwygContent;
        ArrayList<MimeBodyPart> bodyParts = new ArrayList<MimeBodyPart>();
        int idCount = 0;
        ArrayList<Pattern> linkPatterns = new ArrayList<Pattern>(CKEDITOR_LINK_PATTERNS);
        linkPatterns.addAll(GALLERY_CONTENT_LINK_PATTERNS);
        for (String link : StringDataExtractor.from(transformedWysiwygContent).withDirectives(StringDataExtractor.RegexpPatternDirective.regexps(linkPatterns, 1)).extract()) {
            String cid = "link-content-" + idCount++;
            transformedWysiwygContent = this.replaceLinkByCid(transformedWysiwygContent, link, cid);
            MimeBodyPart mbp = new MimeBodyPart();
            String linkForDataSource = link;
            if (!linkForDataSource.toLowerCase().startsWith(URLManager.getCurrentServerURL().toLowerCase())) {
                linkForDataSource = URLManager.getCurrentServerURL() + link;
            }
            linkForDataSource = linkForDataSource.replace("&amp;", "&");
            URLDataSource uds = new URLDataSource(new URL(linkForDataSource));
            mbp.setDataHandler(new DataHandler((DataSource)uds));
            mbp.setHeader("Content-ID", "<" + cid + ">");
            bodyParts.add(mbp);
        }
        HashMap<String, String> attachmentCidCache = new HashMap<String, String>();
        for (String attachmentUrlLink : this.extractAllLinksOfReferencedAttachments(transformedWysiwygContent)) {
            SilverpeasFile attachmentFile = SilverpeasFileProvider.getFile(attachmentUrlLink);
            if (!attachmentFile.exists() || !attachmentFile.isImage()) continue;
            String cid = (String)attachmentCidCache.get(attachmentUrlLink);
            if (cid == null) {
                cid = "attachment-content-" + idCount++;
                attachmentCidCache.put(attachmentUrlLink, cid);
            }
            transformedWysiwygContent = this.replaceLinkByCid(transformedWysiwygContent, attachmentUrlLink, cid);
            MimeBodyPart mbp = new MimeBodyPart();
            FileDataSource fds = new FileDataSource((File)attachmentFile);
            mbp.setDataHandler(new DataHandler((DataSource)fds));
            mbp.setHeader("Content-ID", "<" + cid + ">");
            bodyParts.add(mbp);
        }
        return new MailResult(transformedWysiwygContent, bodyParts);
    }

    private String replaceLinkByCid(String wysiwygContent, String link, String cid) {
        return wysiwygContent.replace("=\"" + link + "\"", "=\"cid:" + cid + "\"");
    }

    List<String> extractAllLinksOfReferencedAttachments(String wysiwygContent) {
        return StringDataExtractor.from(wysiwygContent).withDirectives(StringDataExtractor.RegexpPatternDirective.regexps(ATTACHMENT_LINK_PATTERNS, 1)).extract();
    }

    public static class MailResult {
        private final String wysiwygContent;
        private final List<MimeBodyPart> bodyParts;

        public MailResult(String wysiwygContent, List<MimeBodyPart> bodyParts) {
            this.wysiwygContent = wysiwygContent;
            this.bodyParts = bodyParts;
        }

        public String getWysiwygContent() {
            return this.wysiwygContent;
        }

        protected List<MimeBodyPart> getBodyParts() {
            return this.bodyParts;
        }

        public void applyOn(Multipart multipart) throws Exception {
            for (MimeBodyPart mimeBodyPart : this.getBodyParts()) {
                multipart.addBodyPart((BodyPart)mimeBodyPart);
            }
        }
    }
}

