/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.accesscontrol;

import com.silverpeas.accesscontrol.AccessControlContext;
import com.silverpeas.accesscontrol.AccessControlOperation;
import com.silverpeas.accesscontrol.AccessController;
import com.silverpeas.util.StringUtil;
import com.stratelia.webactiv.SilverpeasRole;
import com.stratelia.webactiv.util.WAPrimaryKey;
import java.util.EnumSet;
import java.util.Set;
import org.apache.commons.lang.NotImplementedException;

public abstract class AbstractAccessController<T>
implements AccessController<T> {
    @Override
    public final boolean isUserAuthorized(String userId, T object) {
        return this.isUserAuthorized(userId, object, AccessControlContext.init());
    }

    public Set<SilverpeasRole> getUserRoles(AccessControlContext context, String userId, T object) {
        String cacheKey = this.buildUserRoleCacheKey(context, userId, object);
        EnumSet<SilverpeasRole> userRoles = context.get(cacheKey, Set.class);
        if (userRoles == null) {
            userRoles = EnumSet.noneOf(SilverpeasRole.class);
            this.fillUserRoles(userRoles, context, userId, object);
            context.put(cacheKey, userRoles);
        }
        return userRoles;
    }

    protected void fillUserRoles(Set<SilverpeasRole> userRoles, AccessControlContext context, String userId, T object) {
        throw new NotImplementedException();
    }

    private String buildUserRoleCacheKey(AccessControlContext context, String userId, T object) {
        StringBuilder cacheKey = new StringBuilder(this.getClass().getName()).append("@#@");
        cacheKey.append("USERID").append(userId).append("@#@");
        cacheKey.append("OBJECTID");
        if (object instanceof String) {
            cacheKey.append(object);
        } else if (object instanceof WAPrimaryKey) {
            WAPrimaryKey pk = (WAPrimaryKey)object;
            cacheKey.append(pk.getId()).append("|").append(pk.getInstanceId());
        } else if (object != null) {
            throw new NotImplementedException();
        }
        EnumSet<AccessControlOperation> orderedOperations = EnumSet.copyOf(context.getOperations());
        cacheKey.append("@#@").append("OPERATIONS").append(StringUtil.join((Object[])orderedOperations.toArray(), (String)"|"));
        return cacheKey.toString();
    }
}

