/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.accesscontrol;

import com.silverpeas.accesscontrol.AccessControlOperation;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class AccessControlContext {
    private Set<AccessControlOperation> operations = EnumSet.noneOf(AccessControlOperation.class);
    private Map<String, Object> cache = new HashMap<String, Object>();

    public static AccessControlContext init() {
        return new AccessControlContext();
    }

    private AccessControlContext() {
    }

    public AccessControlContext onOperationsOf(AccessControlOperation ... operations) {
        Collections.addAll(this.operations, operations);
        return this;
    }

    public Set<AccessControlOperation> getOperations() {
        if (this.operations.isEmpty()) {
            return Collections.unmodifiableSet(Collections.singleton(AccessControlOperation.unknown));
        }
        return Collections.unmodifiableSet(this.operations);
    }

    public <T> AccessControlContext put(String key, T value) {
        this.cache.put(key, value);
        return this;
    }

    public <T> T get(String key, Class<T> classType) {
        Object value = this.cache.get(key);
        if (value == null || !classType.isAssignableFrom(value.getClass())) {
            return null;
        }
        return (T)value;
    }
}

