/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.admin.components;

import com.silverpeas.admin.components.ComponentsInstanciatorIntf;
import com.silverpeas.admin.components.InstanciationException;
import com.silverpeas.admin.components.ObjectFactory;
import com.silverpeas.admin.components.WAComponent;
import com.silverpeas.util.FileUtil;
import com.silverpeas.util.i18n.I18NHelper;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.util.ResourceLocator;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.NameFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;

public class Instanciateur {
    private static final ResourceLocator resources = new ResourceLocator("org.silverpeas.beans.admin.instance.control.instanciator", "");
    private static final String xmlPackage = resources.getString("xmlPackage").trim();
    private static Connection connection = null;
    private static String spaceId = "";
    private static String componentId = "";
    private static String userId = "";
    private static Map<String, WAComponent> componentsByName = new HashMap<String, WAComponent>();
    private static final ObjectFactory objectFactory = new ObjectFactory();
    private static final XMLInputFactory factory = XMLInputFactory.newFactory();

    public Connection getConnection() {
        return connection;
    }

    public void setConnection(Connection connection) {
        Instanciateur.connection = connection;
    }

    public String getSpaceId() {
        return spaceId;
    }

    public void setSpaceId(String sSpaceId) {
        spaceId = sSpaceId;
    }

    public String getComponentId() {
        return componentId;
    }

    public void setComponentId(String sComponentId) {
        componentId = sComponentId;
    }

    public String getUserId() {
        return userId;
    }

    public void setUserId(String sUserId) {
        userId = sUserId;
    }

    public void instantiateComponentName(String componentName) throws InstanciationException {
        WAComponent waComponent = Instanciateur.getWAComponent(componentName);
        if (waComponent == null) {
            try {
                String fullPath = Instanciateur.getDescriptorFullPath(componentName);
                waComponent = this.loadComponent(fullPath);
            }
            catch (IOException e) {
                throw new InstanciationException("Instanciateur.instantiateComponentName", 5, e.getMessage(), e);
            }
            catch (JAXBException e) {
                throw new InstanciationException("Instanciateur.instantiateComponentName", 5, e.getMessage(), (Exception)((Object)e));
            }
            catch (XMLStreamException e) {
                throw new InstanciationException("Instanciateur.instantiateComponentName", 5, e.getMessage(), e);
            }
        }
        this.instantiateComponent(waComponent);
    }

    public void instantiateComponent(WAComponent wac) throws InstanciationException {
        try {
            SilverTrace.info("admin", "Instanciateur.instantiateComponent", "admin.MSG_INFO_INSTANCIATE_COMPONENT", wac.toString());
            Class<?> c = Class.forName(wac.getInstanceClassName());
            ComponentsInstanciatorIntf myInstantiator = (ComponentsInstanciatorIntf)c.newInstance();
            myInstantiator.create(connection, spaceId, componentId, userId);
        }
        catch (ClassNotFoundException cnfe) {
            throw new InstanciationException("Instanciateur.instantiateComponent", 5, "root.EX_CLASS_NOT_FOUND", cnfe);
        }
        catch (InstantiationException ie) {
            throw new InstanciationException("Instanciateur.instantiateComponent", 5, "root.EX_INSTANTIATION", ie);
        }
        catch (IllegalAccessException iae) {
            throw new InstanciationException("Instanciateur.instantiateComponent", 5, "root.EX_ILLEGAL_ACCESS", iae);
        }
    }

    public void unInstantiateComponentName(String componentName) throws InstanciationException {
        try {
            WAComponent component = componentsByName.get(componentName);
            if (component == null) {
                String fullPath = Instanciateur.getDescriptorFullPath(componentName);
                component = this.loadComponent(fullPath);
            }
            this.unInstantiateComponent(component);
        }
        catch (IOException e) {
            throw new InstanciationException("Instanciateur.unInstantiateComponentName", 5, e.getMessage(), e);
        }
        catch (JAXBException e) {
            throw new InstanciationException("Instanciateur.unInstantiateComponentName", 5, e.getMessage(), (Exception)((Object)e));
        }
        catch (XMLStreamException e) {
            throw new InstanciationException("Instanciateur.unInstantiateComponentName", 5, e.getMessage(), e);
        }
    }

    public void unInstantiateComponent(WAComponent wac) throws InstanciationException {
        try {
            SilverTrace.info("admin", "Instanciateur.unInstantiateComponent", "admin.MSG_INFO_UNINSTANCIATE_COMPONENT", wac.toString());
            Class<?> c = Class.forName(wac.getInstanceClassName());
            ComponentsInstanciatorIntf myInstantiator = (ComponentsInstanciatorIntf)c.newInstance();
            myInstantiator.delete(connection, spaceId, componentId, userId);
        }
        catch (ClassNotFoundException cnfe) {
            throw new InstanciationException("Instanciateur.unInstantiateComponent", 5, "root.EX_CLASS_NOT_FOUND", cnfe);
        }
        catch (InstantiationException ie) {
            throw new InstanciationException("Instanciateur.unInstantiateComponent", 5, "root.EX_INSTANTIATION", ie);
        }
        catch (IllegalAccessException iae) {
            throw new InstanciationException("Instanciateur.unInstantiateComponent", 5, "root.EX_ILLEGAL_ACCESS", iae);
        }
    }

    public static synchronized WAComponent getWAComponent(String componentName) {
        return componentsByName.get(componentName);
    }

    public static boolean isWorkflow(String componentName) {
        WAComponent descriptor = Instanciateur.getWAComponent(componentName);
        return descriptor != null && "RprocessManager".equalsIgnoreCase(descriptor.getRouter());
    }

    public static synchronized Map<String, WAComponent> getWAComponents() {
        return Collections.unmodifiableMap(componentsByName);
    }

    public static synchronized Map<String, String> getAllComponentsNames() {
        HashMap<String, String> hComponents = new HashMap<String, String>();
        Collection<WAComponent> components = componentsByName.values();
        for (WAComponent component : components) {
            hComponents.put(component.getName(), component.getLabel().get(I18NHelper.defaultLanguage));
        }
        return hComponents;
    }

    public static synchronized List<WAComponent> getVisibleComponentsForPersonalSpace() {
        ArrayList<WAComponent> visibleComponents = new ArrayList<WAComponent>();
        Collection<WAComponent> components = componentsByName.values();
        for (WAComponent component : components) {
            if (!component.isVisibleInPersonalSpace()) continue;
            visibleComponents.add(component);
        }
        return visibleComponents;
    }

    public static synchronized void rebuildWAComponentCache() throws InstanciationException {
        componentsByName.clear();
        try {
            Instanciateur.buildWAComponentList();
        }
        catch (IOException e) {
            SilverTrace.fatal("admin", "Instanciateur.rebuildWAComponentCache()", "admin.MSG_INSTANCIATEUR_RESOURCES_NOT_FOUND", e);
            throw new InstanciationException("Instanciateur.rebuildWAComponentCache()", 5, "admin.EX_ERR_INSTANTIATE_COMPONENTS", e);
        }
        catch (JAXBException e) {
            SilverTrace.fatal("admin", "Instanciateur.rebuildWAComponentCache()", "admin.MSG_INSTANCIATEUR_RESOURCES_NOT_FOUND", e);
            throw new InstanciationException("Instanciateur.rebuildWAComponentCache()", 5, "admin.EX_ERR_INSTANTIATE_COMPONENTS", (Exception)((Object)e));
        }
        catch (XMLStreamException e) {
            SilverTrace.fatal("admin", "Instanciateur.rebuildWAComponentCache()", "admin.MSG_INSTANCIATEUR_RESOURCES_NOT_FOUND", e);
            throw new InstanciationException("Instanciateur.rebuildWAComponentCache()", 5, "admin.EX_ERR_INSTANTIATE_COMPONENTS", e);
        }
    }

    private static Collection<File> getFileList() {
        return FileUtils.listFiles((File)new File(xmlPackage), (String[])new String[]{"xml"}, (boolean)true);
    }

    static String getDescriptorFullPath(String componentName) throws IOException {
        NameFileFilter filter = new NameFileFilter(componentName + ".xml");
        ArrayList list = new ArrayList(FileUtils.listFiles((File)new File(xmlPackage), (IOFileFilter)filter, (IOFileFilter)TrueFileFilter.INSTANCE));
        if (!list.isEmpty()) {
            return ((File)list.get(0)).getCanonicalPath();
        }
        return new File(xmlPackage, componentName + ".xml").getCanonicalPath();
    }

    private static synchronized void buildWAComponentList() throws IOException, JAXBException, XMLStreamException {
        Collection<File> files = Instanciateur.getFileList();
        for (File xmlFile : files) {
            String componentName = FilenameUtils.getBaseName((String)xmlFile.getName());
            SilverTrace.info("admin", "Instanciateur.buildWAComponentList", "admin.MSG_INFO_BUILD_WA_COMPONENT_LIST", "component name: '" + componentName + "', full path: '" + xmlFile.getCanonicalPath() + "'");
            componentsByName.put(componentName, Instanciateur.loadComponent(xmlFile));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static WAComponent loadComponent(File file) throws IOException, JAXBException, XMLStreamException {
        JAXBContext context = JAXBContext.newInstance((String)"com.silverpeas.admin.components");
        Unmarshaller unmarshaller = context.createUnmarshaller();
        FileInputStream in = new FileInputStream(file);
        try {
            WAComponent wAComponent = (WAComponent)unmarshaller.unmarshal(factory.createXMLStreamReader(in), WAComponent.class).getValue();
            return wAComponent;
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
    }

    WAComponent loadComponent(String path) throws IOException, JAXBException, XMLStreamException {
        File file = new File(path);
        return Instanciateur.loadComponent(file);
    }

    public static void saveComponent(WAComponent waComponent, String fileName) throws JAXBException, InstanciationException {
        Instanciateur.saveComponent(waComponent, fileName, false);
    }

    public static void saveComponent(WAComponent waComponent, String fileName, boolean workflow) throws JAXBException, InstanciationException {
        JAXBContext context = JAXBContext.newInstance((String)"com.silverpeas.admin.components");
        Marshaller marshaller = context.createMarshaller();
        marshaller.setProperty("jaxb.schemaLocation", (Object)"http://silverpeas.org/xml/ns/component http://www.silverpeas.org/xsd/component.xsd");
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        File file = Instanciateur.getFile(fileName, workflow);
        marshaller.marshal(objectFactory.createWAComponent(waComponent), file);
        Instanciateur.rebuildWAComponentCache();
    }

    public static void removeWorkflow(String fileName) throws IOException, InstanciationException {
        File file = Instanciateur.getFile(fileName, true);
        FileUtil.forceDeletion(file);
        Instanciateur.rebuildWAComponentCache();
    }

    private static File getFile(String fileName, boolean workflow) {
        String path = Instanciateur.getXMLPackage() + File.separatorChar;
        if (workflow) {
            path = path + "workflows" + File.separatorChar;
        }
        return new File(path + fileName);
    }

    public static String getXMLPackage() {
        return xmlPackage;
    }

    static {
        try {
            Instanciateur.buildWAComponentList();
        }
        catch (Exception mre) {
            SilverTrace.fatal("admin", "Instanciateur.static", "admin.MSG_INSTANCIATEUR_RESOURCES_NOT_FOUND", mre);
        }
    }
}

