/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.admin.components;

import com.silverpeas.admin.components.LocalizedParameter;
import com.silverpeas.admin.components.LocalizedParameterList;
import com.silverpeas.admin.components.Parameter;
import com.silverpeas.admin.components.ParameterSorter;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ParameterList
extends ArrayList<Parameter> {
    public ParameterList() {
    }

    public ParameterList(List<Parameter> parameters) {
        super(parameters);
    }

    public void setValues(List<Parameter> parameters) {
        for (Parameter parameterToMerge : parameters) {
            Parameter parameter = this.getParameterByName(parameterToMerge.getName());
            if (parameter == null) {
                SilverTrace.info("admin", "ParameterList.setValues", "root.MSG_GEN_PARAM_VALUE", "dbParameter '" + parameterToMerge.getName() + "' is no more use !");
                continue;
            }
            parameter.setValue(parameterToMerge.getValue());
        }
    }

    public List<Parameter> getVisibleParameters() {
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        for (Parameter parameter : this) {
            if (!parameter.isVisible()) continue;
            parameters.add(parameter);
        }
        return parameters;
    }

    public List<Parameter> getHiddenParameters() {
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        for (Parameter parameter : this) {
            if (!parameter.isHidden()) continue;
            parameters.add(parameter);
        }
        return parameters;
    }

    public void sort() {
        Collections.sort(this, new ParameterSorter());
    }

    private Parameter getParameterByName(String name) {
        for (Parameter param : this) {
            if (!param.getName().equals(name)) continue;
            return param;
        }
        return null;
    }

    public boolean isVisible() {
        for (Parameter param : this) {
            if (!param.isVisible()) continue;
            return true;
        }
        return false;
    }

    public LocalizedParameterList localize(String lang) {
        LocalizedParameterList localized = new LocalizedParameterList();
        for (Parameter param : this) {
            localized.add(new LocalizedParameter(param, lang));
        }
        return localized;
    }

    @Override
    public ParameterList clone() {
        ParameterList clone = new ParameterList();
        for (Parameter param : this) {
            clone.add(param.clone());
        }
        return clone;
    }
}

