/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.admin.service;

import com.silverpeas.admin.service.UserService;
import com.silverpeas.ui.DisplayI18NHelper;
import com.silverpeas.util.StringUtil;
import com.silverpeas.util.template.SilverpeasTemplate;
import com.silverpeas.util.template.SilverpeasTemplateFactory;
import com.stratelia.silverpeas.notificationManager.NotificationManagerException;
import com.stratelia.silverpeas.notificationManager.NotificationMetaData;
import com.stratelia.silverpeas.notificationManager.NotificationSender;
import com.stratelia.silverpeas.notificationManager.UserRecipient;
import com.stratelia.silverpeas.peasCore.URLManager;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.beans.admin.Admin;
import com.stratelia.webactiv.beans.admin.AdminException;
import com.stratelia.webactiv.beans.admin.AdminReference;
import com.stratelia.webactiv.beans.admin.Domain;
import com.stratelia.webactiv.beans.admin.UserDetail;
import com.stratelia.webactiv.beans.admin.UserFull;
import com.stratelia.webactiv.util.ResourceLocator;
import java.util.HashMap;
import java.util.Random;
import javax.annotation.PostConstruct;
import javax.inject.Named;
import org.silverpeas.admin.user.constant.UserAccessLevel;

@Named(value="silverpeasUserService")
public class UserServiceLegacy
implements UserService {
    ResourceLocator multilang = null;

    @PostConstruct
    void init() {
        this.multilang = new ResourceLocator("com.silverpeas.social.multilang.registration", DisplayI18NHelper.getDefaultLanguage());
    }

    @Override
    public String registerUser(String firstName, String lastName, String email, String domainId) throws AdminException {
        return this.registerUser(firstName, lastName, email, domainId, UserAccessLevel.USER);
    }

    @Override
    public String registerUser(String firstName, String lastName, String email, String domainId, UserAccessLevel accessLevel) throws AdminException {
        Admin admin = AdminReference.getAdminService();
        String login = this.generateLogin(admin, domainId, email);
        if (login == null) {
            throw new AdminException("SilverpeasAdminServiceLegacy.createGuestUser", 4, "admin.EX_NO_LOGIN_AVAILABLE");
        }
        String password = this.generatePassword();
        UserDetail user = new UserDetail();
        user.setId("-1");
        user.setFirstName(firstName);
        user.setLastName(lastName);
        user.seteMail(email);
        user.setLogin(login);
        user.setDomainId(domainId);
        user.setAccessLevel(accessLevel);
        String userId = admin.addUser(user);
        if (!StringUtil.isDefined(userId)) {
            throw new AdminException("SilverpeasAdminServiceLegacy.createGuestUser", 4, "admin.EX_ADD_USER_FAILED");
        }
        UserFull uf = admin.getUserFull(userId);
        if (uf != null) {
            uf.setPasswordValid(true);
            uf.setPassword(password);
            userId = admin.updateUserFull(uf);
            if (!StringUtil.isDefined(userId)) {
                throw new AdminException("SilverpeasAdminServiceLegacy.createGuestUser", 4, "admin.EX_ADD_USER_FAILED");
            }
        }
        Domain domain = admin.getDomain(domainId);
        this.sendCredentialsToUser(uf, password, domain.getSilverpeasServerURL());
        return userId;
    }

    @Override
    public UserDetail findUser(String userId) throws AdminException {
        Admin admin = AdminReference.getAdminService();
        return admin.getUserDetail(userId);
    }

    private String generatePassword() {
        Random random = new Random();
        byte[] password = new byte[8];
        for (int i = 0; i < 8; ++i) {
            password[i] = (byte)(65 + random.nextInt(26));
        }
        return new String(password);
    }

    private String generateLogin(Admin admin, String domainId, String email) {
        try {
            String userId = admin.getUserIdByLoginAndDomain(email, domainId);
            if (userId == null) {
                return email;
            }
        }
        catch (AdminException e) {
            SilverTrace.debug("admin", "SilverpeasAdminServiceLegacy.generateLogin", "firstTryFailed", "firstName :" + email, e);
            return email;
        }
        return null;
    }

    private void sendCredentialsToUser(UserFull user, String password, String silverpeasServerURL) {
        try {
            HashMap<String, SilverpeasTemplate> templates = new HashMap<String, SilverpeasTemplate>();
            String subject = this.multilang.getString("credentialsMail.subject");
            NotificationMetaData notifMetaData = new NotificationMetaData(0, subject, templates, "credentialsMail");
            ResourceLocator generalLook = new ResourceLocator("com.stratelia.silverpeas.lookAndFeel.generalLook", "");
            String loginPage = generalLook.getString("loginPage", "defaultLogin.jsp");
            StringBuffer url = new StringBuffer();
            if (!loginPage.startsWith("http")) {
                url.append(silverpeasServerURL);
                if (!URLManager.getApplicationURL().startsWith("/")) {
                    url.append("/");
                }
                url.append(URLManager.getApplicationURL());
                if (!loginPage.startsWith("/")) {
                    url.append("/");
                }
            }
            url.append(loginPage).append("?DomainId=").append(user.getDomainId());
            Admin admin = AdminReference.getAdminService();
            Domain svpDomain = admin.getDomain(user.getDomainId());
            SilverpeasTemplate template = this.getNewTemplate();
            template.setAttribute("fullName", user.getDisplayedName());
            template.setAttribute("login", user.getLogin());
            template.setAttribute("password", password);
            if (admin.getAllDomains().length > 1) {
                template.setAttribute("domain", svpDomain);
            }
            template.setAttribute("url", url.toString());
            templates.put(DisplayI18NHelper.getDefaultLanguage(), template);
            notifMetaData.addLanguage(DisplayI18NHelper.getDefaultLanguage(), subject, "");
            notifMetaData.setSender("0");
            notifMetaData.addUserRecipients(new UserRecipient[]{new UserRecipient(user.getId())});
            this.notifyUser(notifMetaData, null);
        }
        catch (Exception e) {
            SilverTrace.error("socialNetwork", "UserServiceLegacy.sendCredentialsToUser", "EX_SEND_NOTIFICATION_FAILED", "userId=" + user.getId(), e);
        }
    }

    private SilverpeasTemplate getNewTemplate() {
        return SilverpeasTemplateFactory.createSilverpeasTemplateOnCore("socialNetwork");
    }

    private void notifyUser(NotificationMetaData notifMetaData, String componentId) throws AdminException {
        try {
            NotificationSender notifSender = new NotificationSender(componentId);
            notifSender.notifyUser(notifMetaData);
        }
        catch (NotificationManagerException e) {
            throw new AdminException("SilverpeasAdminServiceLegacy.notifyUser", 4, "EX_SEND_NOTIFICATION_FAILED", e);
        }
    }

    @Override
    public void migrateUserToDomain(UserDetail userDetail, String targetDomainId) throws AdminException {
        Admin admin = AdminReference.getAdminService();
        admin.migrateUser(userDetail, targetDomainId);
    }

    @Override
    public void updateUser(UserDetail userDetail) throws AdminException {
        Admin admin = AdminReference.getAdminService();
        admin.updateUser(userDetail);
    }
}

