/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.calendar;

import com.silverpeas.SilverpeasContent;
import com.silverpeas.annotation.constraint.DateRange;
import com.silverpeas.calendar.CalendarEventAttendees;
import com.silverpeas.calendar.CalendarEventCategories;
import com.silverpeas.calendar.CalendarEventRecurrence;
import com.silverpeas.calendar.Datable;
import com.silverpeas.calendar.Date;
import com.silverpeas.util.StringUtil;
import java.io.Serializable;
import java.net.URL;

@DateRange(startDate="startDate", endDate="endDate")
public class CalendarEvent
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Datable<?> startDate;
    private Datable<?> endDate;
    private String title = "";
    private String description = "";
    private String location = "";
    private URL url = null;
    private String accessLevel = "PUBLIC";
    private int priority = 0;
    private CalendarEventRecurrence recurrence = CalendarEventRecurrence.NO_RECURRENCE;
    private final CalendarEventCategories categories = new CalendarEventCategories();
    private final CalendarEventAttendees attendees = new CalendarEventAttendees();
    private String id = "";

    public static <T extends Datable<?>> CalendarEvent anEventAt(T startDate) {
        return new CalendarEvent().startingAt(startDate).endingAt(startDate);
    }

    public static <T extends Datable<?>> CalendarEvent anEventAt(T startDate, T endDate) {
        return new CalendarEvent().startingAt(startDate).endingAt(endDate);
    }

    public CalendarEvent withAccessLevel(String accessLevel) {
        if (!StringUtil.isDefined(accessLevel)) {
            throw new IllegalArgumentException("The accessLevel parameter isn't defined!");
        }
        this.accessLevel = accessLevel;
        return this;
    }

    public CalendarEvent endingAt(Datable<?> endDate) {
        this.endDate = endDate.clone();
        return this;
    }

    public CalendarEvent withPriority(int priority) {
        this.priority = priority;
        return this;
    }

    public String getLocation() {
        return this.location;
    }

    public CalendarEvent withLocation(String location) {
        this.location = location == null ? "" : location;
        return this;
    }

    public URL getUrl() {
        return this.url;
    }

    public CalendarEvent withUrl(URL url) {
        this.url = url;
        return this;
    }

    public CalendarEvent startingAt(Datable<?> startDate) {
        this.startDate = startDate.clone();
        return this;
    }

    public CalendarEventAttendees getAttendees() {
        return this.attendees;
    }

    public CalendarEventCategories getCategories() {
        return this.categories;
    }

    public String getAccessLevel() {
        return this.accessLevel;
    }

    public String getDescription() {
        return this.description;
    }

    public Datable<?> getEndDate() {
        return this.endDate.clone();
    }

    public String getTitle() {
        return this.title;
    }

    public int getPriority() {
        return this.priority;
    }

    public Datable<?> getStartDate() {
        return this.startDate.clone();
    }

    public CalendarEvent recur(CalendarEventRecurrence recurrence) {
        this.recurrence = recurrence;
        return this;
    }

    public CalendarEvent withTitle(String title) {
        this.title = title == null ? "" : title;
        return this;
    }

    public CalendarEvent withDescription(String description) {
        this.description = description == null ? "" : description;
        return this;
    }

    public CalendarEventRecurrence getRecurrence() {
        return this.recurrence;
    }

    public boolean isRecurring() {
        return this.recurrence != CalendarEventRecurrence.NO_RECURRENCE;
    }

    public boolean isOnAllDay() {
        return this.startDate instanceof Date || this.endDate instanceof Date;
    }

    public CalendarEvent from(SilverpeasContent content) {
        this.identifiedBy(content.getComponentInstanceId(), content.getId());
        this.title = content.getTitle();
        this.description = content.getDescription();
        return this;
    }

    public CalendarEvent identifiedBy(String appId, String eventId) {
        this.id = appId + "-" + eventId;
        return this;
    }

    public String getId() {
        return this.id;
    }

    private CalendarEvent() {
    }
}

