/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.comment.service;

import com.silverpeas.comment.service.CommentService;
import com.silverpeas.comment.service.CommentUserNotificationService;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import javax.inject.Inject;

public class CommentServiceFactory {
    private static final CommentServiceFactory instance = new CommentServiceFactory();
    @Inject
    private CommentService commentService;
    @Inject
    private CommentUserNotificationService commentUserNotificationService;

    public static CommentServiceFactory getFactory() {
        return instance;
    }

    public CommentService getCommentService() {
        if (this.commentService == null) {
            SilverTrace.error("comment", this.getClass().getSimpleName() + ".getCommentService()", "EX_NO_MESSAGES", "IoC container not bootstrapped or no CommentService bean found!");
        }
        return this.commentService;
    }

    public CommentUserNotificationService getCommentUserNotificationService() {
        if (this.commentUserNotificationService == null) {
            SilverTrace.error("comment", this.getClass().getSimpleName() + ".getCommentUserNotificationService()", "EX_NO_MESSAGES", "IoC container not bootstrapped or no CommentUserNotificationService bean found!");
        }
        return this.commentUserNotificationService;
    }

    private CommentServiceFactory() {
    }
}

