/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.comment.service;

import com.silverpeas.SilverpeasContent;
import com.silverpeas.SilverpeasToolContent;
import com.silverpeas.comment.model.Comment;
import com.silverpeas.comment.service.CommentService;
import com.silverpeas.notification.builder.AbstractTemplateUserNotificationBuilder;
import com.silverpeas.notification.model.NotificationResourceData;
import com.silverpeas.util.StringUtil;
import com.silverpeas.util.template.SilverpeasTemplate;
import com.silverpeas.util.template.SilverpeasTemplateFactory;
import com.stratelia.silverpeas.notificationManager.constant.NotifAction;
import com.stratelia.webactiv.util.ResourceLocator;
import java.util.Collection;
import java.util.Properties;
import java.util.Set;

public class CommentUserNotification
extends AbstractTemplateUserNotificationBuilder<SilverpeasContent> {
    public static final String DEFAULT_SUBJECT_COMMENT_ADDING = "comments.commentAddingSubject";
    public static final String NOTIFICATION_COMMENT_ATTRIBUTE = "comment";
    public static final String NOTIFICATION_CONTENT_ATTRIBUTE = "content";
    private final CommentService commentService;
    private final String subjectKey;
    private final ResourceLocator componentMessages;
    private final Comment comment;
    private final Set<String> recipients;

    public CommentUserNotification(CommentService commentService, Comment comment, SilverpeasContent commentedContent, String subjectKey, ResourceLocator componentMessages, Set<String> recipients) {
        super(commentedContent, null, "commented");
        this.commentService = commentService;
        this.comment = comment;
        this.subjectKey = subjectKey;
        this.componentMessages = componentMessages;
        this.recipients = recipients;
    }

    @Override
    protected String getBundleSubjectKey() {
        return this.subjectKey;
    }

    @Override
    protected String getTitle() {
        String subject = this.componentMessages.getString(this.getBundleSubjectKey());
        if (!StringUtil.isDefined(subject)) {
            subject = this.commentService.getComponentMessages(this.componentMessages.getLanguage()).getString(DEFAULT_SUBJECT_COMMENT_ADDING);
        }
        return subject;
    }

    @Override
    protected Collection<String> getUserIdsToNotify() {
        return this.recipients;
    }

    @Override
    protected void perform(SilverpeasContent resource) {
        this.getNotificationMetaData().setOriginalExtraMessage(this.comment.getMessage());
    }

    @Override
    protected void performTemplateData(String language, SilverpeasContent resource, SilverpeasTemplate template) {
        this.componentMessages.setLanguage(language);
        this.getNotificationMetaData().addLanguage(language, this.getTitle(), "");
    }

    @Override
    protected void performNotificationResource(String language, SilverpeasContent resource, NotificationResourceData notificationResourceData) {
        notificationResourceData.setResourceName(resource.getTitle());
        notificationResourceData.setResourceDescription(resource.getDescription());
    }

    @Override
    protected SilverpeasTemplate createTemplate() {
        ResourceLocator settings = this.commentService.getComponentSettings();
        Properties templateConfiguration = new Properties();
        templateConfiguration.setProperty("template.root.dir", settings.getString("templatePath"));
        templateConfiguration.setProperty("template.customer.dir", settings.getString("customersTemplatePath"));
        SilverpeasTemplate template = SilverpeasTemplateFactory.createSilverpeasTemplate(templateConfiguration);
        template.setAttribute(NOTIFICATION_CONTENT_ATTRIBUTE, this.getResource());
        template.setAttribute(NOTIFICATION_COMMENT_ATTRIBUTE, this.comment);
        return template;
    }

    @Override
    protected String getTemplatePath() {
        return null;
    }

    @Override
    protected NotifAction getAction() {
        return NotifAction.COMMENT;
    }

    @Override
    protected String getComponentInstanceId() {
        return this.comment.getCommentPK().getInstanceId();
    }

    @Override
    protected String getSender() {
        return this.comment.getCreator().getId();
    }

    @Override
    protected boolean isSendImmediatly() {
        return this.getResource() instanceof SilverpeasToolContent;
    }

    @Override
    protected String getMultilangPropertyFile() {
        return "org.silverpeas.util.comment.multilang.comment";
    }

    @Override
    protected String getContributionAccessLinkLabelBundleKey() {
        return "comment.notifCommentLinkLabel";
    }
}

