/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.comment.socialnetwork;

import com.silverpeas.comment.model.Comment;
import com.silverpeas.socialnetwork.model.AbstractSocialInformation;
import com.silverpeas.socialnetwork.model.SocialInformationType;

public class SocialInformationComment
extends AbstractSocialInformation {
    private final Comment comment;

    public SocialInformationComment(Comment comment) {
        this.comment = comment;
        this.setAuthor(comment.getCreator().getId());
        if (comment.getModificationDate() != null) {
            this.setDate(comment.getModificationDate());
            this.setUpdated(true);
        } else {
            this.setDate(comment.getCreationDate());
            this.setUpdated(false);
        }
        String instanceId = comment.getComponentInstanceId();
        SocialInformationType type = SocialInformationType.COMMENTPUBLICATION;
        if (instanceId.startsWith("blog")) {
            type = SocialInformationType.COMMENTPOST;
        } else if (instanceId.startsWith("quickinfo")) {
            type = SocialInformationType.COMMENTNEWS;
        } else if (instanceId.startsWith("gallery")) {
            type = SocialInformationType.COMMENTMEDIA;
        }
        this.setType(type.toString());
        this.setDescription(comment.getMessage());
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SocialInformationComment other = (SocialInformationComment)obj;
        if (this.type == null ? other.type != null : !this.type.equals(other.type)) {
            return false;
        }
        if (this.author == null ? other.author != null : !this.author.equals(other.author)) {
            return false;
        }
        if (!(this.date == other.date || this.date != null && this.date.equals(other.date))) {
            return false;
        }
        if (this.url == null ? other.url != null : !this.url.equals(other.url)) {
            return false;
        }
        if (this.getTitle() == null ? other.getTitle() != null : !this.getTitle().equals(other.getTitle())) {
            return false;
        }
        return !(this.getDescription() == null ? other.getDescription() != null : !this.getDescription().equals(other.getDescription()));
    }

    @Override
    public int hashCode() {
        int hash = 7;
        hash = 43 * hash + (this.type != null ? this.type.hashCode() : 0);
        hash = 43 * hash + (this.author != null ? this.author.hashCode() : 0);
        hash = 43 * hash + (this.date != null ? this.date.hashCode() : 0);
        hash = 43 * hash + (this.url != null ? this.url.hashCode() : 0);
        return hash;
    }

    public Comment getComment() {
        return this.comment;
    }
}

