/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.export;

import com.silverpeas.export.ImportExportDescriptor;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.apache.commons.io.output.WriterOutputStream;
import org.silverpeas.util.Charsets;

public class ExportDescriptor
extends ImportExportDescriptor {
    private Writer writer = null;
    private OutputStream outputStream = null;

    public static ExportDescriptor withWriter(Writer writer) {
        ExportDescriptor descriptor = new ExportDescriptor();
        if (writer == null) {
            throw new IllegalArgumentException("The writer cannot be null!");
        }
        descriptor.setWriter(writer);
        descriptor.setOutputStream((OutputStream)new WriterOutputStream(writer, Charsets.UTF_8));
        return descriptor;
    }

    public static ExportDescriptor withOutputStream(OutputStream outputStream) {
        ExportDescriptor descriptor = new ExportDescriptor();
        if (outputStream == null) {
            throw new IllegalArgumentException("The output stream cannot be null!");
        }
        descriptor.setOutputStream(outputStream);
        descriptor.setWriter(new OutputStreamWriter(outputStream));
        return descriptor;
    }

    public Writer getWriter() {
        return this.writer;
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    private void setWriter(Writer writer) {
        this.writer = writer;
    }

    private void setOutputStream(OutputStream outputStream) {
        this.outputStream = outputStream;
    }
}

