/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.export.ical.ical4j;

import com.silverpeas.calendar.Datable;
import com.silverpeas.calendar.Date;
import com.silverpeas.export.EncodingException;
import java.text.ParseException;
import net.fortuna.ical4j.model.DateTime;
import net.fortuna.ical4j.model.TimeZone;
import net.fortuna.ical4j.model.TimeZoneRegistry;
import net.fortuna.ical4j.model.TimeZoneRegistryFactory;

public class ICal4JDateCodec {
    private static final ICal4JDateCodec instance = new ICal4JDateCodec();

    public static ICal4JDateCodec anICal4JDateCodec() {
        return instance;
    }

    public net.fortuna.ical4j.model.Date encode(Datable<?> aDate) throws EncodingException {
        return this.encode(aDate, false);
    }

    public net.fortuna.ical4j.model.Date encodeInUTC(Datable<?> aDate) throws EncodingException {
        return this.encode(aDate, true);
    }

    public net.fortuna.ical4j.model.Date encode(Datable<?> aDate, boolean inUTC) throws EncodingException {
        DateTime iCal4JDate = null;
        try {
            if (aDate instanceof com.silverpeas.calendar.DateTime) {
                if (inUTC) {
                    iCal4JDate = new DateTime(aDate.toICalInUTC());
                } else {
                    iCal4JDate = new DateTime(aDate.toICal());
                    iCal4JDate.setTimeZone(this.getTimeZone(aDate));
                }
            } else if (aDate instanceof Date) {
                iCal4JDate = new net.fortuna.ical4j.model.Date(aDate.toICal());
            }
        }
        catch (ParseException ex) {
            throw new EncodingException(ex.getMessage(), ex);
        }
        return iCal4JDate;
    }

    private TimeZone getTimeZone(Datable<?> date) {
        TimeZoneRegistry registry = TimeZoneRegistryFactory.getInstance().createRegistry();
        return registry.getTimeZone(date.getTimeZone().getID());
    }
}

