/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.form.displayers;

import com.silverpeas.form.FieldTemplate;
import com.silverpeas.form.FormException;
import com.silverpeas.form.PagesContext;
import com.silverpeas.form.Util;
import com.silverpeas.form.displayers.AbstractTextFieldDisplayer;
import com.silverpeas.form.fieldType.TextField;
import com.silverpeas.util.EncodeHelper;
import com.silverpeas.util.StringUtil;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import java.io.PrintWriter;
import java.util.Map;
import org.apache.ecs.Element;
import org.apache.ecs.ElementContainer;
import org.apache.ecs.xhtml.a;
import org.apache.ecs.xhtml.img;
import org.apache.ecs.xhtml.input;

public class EmailFieldDisplayer
extends AbstractTextFieldDisplayer<TextField> {
    public static final String PARAM_MAILTO = "mailto";
    public static final String PARAM_SIZE = "size";

    @Override
    public void addSpecificScript(PrintWriter out, FieldTemplate template, PagesContext pageContext) {
        String language = pageContext.getLanguage();
        String label = template.getLabel(language);
        if (!template.getTypeName().equals("text")) {
            SilverTrace.info("form", "TextFieldDisplayer.displayScripts", "form.INFO_NOT_CORRECT_TYPE", "text");
        }
        if (template.isMandatory() && pageContext.useMandatory()) {
            StringBuilder script = new StringBuilder(10000);
            script.append("   if (!checkemail(field.value)) {\n");
            script.append("     errorMsg+=\"  - '").append(label).append("' ").append(Util.getString("GML.MustContainsEmail", language)).append("\\n\";\n");
            script.append("     errorNb++;\n");
            script.append("   }\n");
            out.print(script.toString());
        }
    }

    @Override
    public void display(PrintWriter out, TextField field, FieldTemplate template, PagesContext pageContext) throws FormException {
        String value;
        String defaultValue;
        String fieldName = Util.getFieldOccurrenceName(template.getFieldName(), field.getOccurrence());
        Map<String, String> parameters = template.getParameters(pageContext.getLanguage());
        String string = defaultValue = parameters.containsKey("default") ? parameters.get("default") : "";
        if (pageContext.isIgnoreDefaultValues()) {
            defaultValue = "";
        }
        String string2 = value = !field.isNull() ? field.getValue(pageContext.getLanguage()) : defaultValue;
        if (pageContext.isBlankFieldsUse()) {
            value = "";
        }
        if (template.isReadOnly() && !template.isHidden()) {
            if (StringUtil.isDefined(value)) {
                if (StringUtil.getBooleanValue(parameters.get(PARAM_MAILTO))) {
                    a mailto = new a();
                    mailto.setHref("mailto:" + value);
                    mailto.addElement(value);
                    out.println(mailto.toString());
                } else {
                    out.println(value);
                }
            }
        } else {
            input inputField = new input();
            inputField.setName(fieldName);
            inputField.setID(fieldName);
            inputField.setValue(EncodeHelper.javaStringToHtmlString(value));
            inputField.setType(template.isHidden() ? "hidden" : "text");
            inputField.setMaxlength(100);
            inputField.setSize(parameters.containsKey(PARAM_SIZE) ? parameters.get(PARAM_SIZE) : "50");
            if (parameters.containsKey("border")) {
                inputField.setBorder(Integer.parseInt(parameters.get("border")));
            }
            if (template.isDisabled()) {
                inputField.setDisabled(true);
            } else if (template.isReadOnly()) {
                inputField.setReadOnly(true);
            }
            img image = null;
            if (template.isMandatory() && !template.isDisabled() && !template.isReadOnly() && !template.isHidden() && pageContext.useMandatory()) {
                image = new img();
                image.setSrc(Util.getIcon("mandatoryField"));
                image.setWidth(5);
                image.setHeight(5);
                image.setBorder(0);
            }
            if (image != null) {
                ElementContainer container = new ElementContainer();
                container.addElement((Element)inputField);
                container.addElement("&nbsp;");
                container.addElement((Element)image);
                out.println(container.toString());
            } else {
                out.println(inputField.toString());
            }
        }
    }
}

