/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.form.displayers;

import com.silverpeas.form.FieldTemplate;
import com.silverpeas.form.FormException;
import com.silverpeas.form.PagesContext;
import com.silverpeas.form.Util;
import com.silverpeas.form.displayers.AbstractFieldDisplayer;
import com.silverpeas.form.fieldType.MultipleUserField;
import com.silverpeas.util.EncodeHelper;
import com.silverpeas.util.StringUtil;
import com.stratelia.silverpeas.peasCore.URLManager;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.fileupload.FileItem;
import org.silverpeas.servlet.FileUploadUtil;

public class MultipleUserFieldDisplayer
extends AbstractFieldDisplayer<MultipleUserField> {
    private static final String ROWS_DEFAULT_VALUE = "5";
    private static final String COLS_DEFAULT_VALUE = "50";

    public String[] getManagedTypes() {
        return new String[]{"multipleUser"};
    }

    @Override
    public void displayScripts(PrintWriter out, FieldTemplate template, PagesContext PagesContext2) throws IOException {
        String language = PagesContext2.getLanguage();
        if (!template.getTypeName().equals("multipleUser")) {
            SilverTrace.info("form", "TextFieldDisplayer.displayScripts", "form.INFO_NOT_CORRECT_TYPE", "multipleUser");
        }
        if (template.isMandatory()) {
            StringBuilder html = new StringBuilder();
            html.append("   if (isWhitespace(stripInitialWhitespace(field.value))) {");
            html.append("      errorMsg+=\"  - '").append(EncodeHelper.javaStringToJsString(template.getLabel(language))).append("' ").append(Util.getString("GML.MustBeFilled", language)).append("\\n\";");
            html.append("      errorNb++;");
            html.append("   }");
            out.println(html.toString());
        }
    }

    @Override
    public void display(PrintWriter out, MultipleUserField field, FieldTemplate template, PagesContext pageContext) throws FormException {
        SilverTrace.info("form", "UserFieldDisplayer.display", "root.MSG_GEN_ENTER_METHOD", "fieldName = " + template.getFieldName() + ", value = " + field.getValue() + ", fieldType = " + field.getTypeName());
        String language = pageContext.getLanguage();
        String selectUserImg = Util.getIcon("userPanel");
        String selectUserLab = Util.getString("userPanel", language);
        Map<String, String> parameters = template.getParameters(pageContext.getLanguage());
        String rows = parameters.containsKey("rows") ? parameters.get("rows") : ROWS_DEFAULT_VALUE;
        String cols = parameters.containsKey("cols") ? parameters.get("cols") : COLS_DEFAULT_VALUE;
        boolean usersOfInstanceOnly = StringUtil.getBooleanValue(parameters.get("usersOfInstanceOnly"));
        String roles = parameters.get("roles");
        if (StringUtil.isDefined(roles)) {
            usersOfInstanceOnly = true;
        }
        String userNames = "";
        String userIds = "";
        StringBuilder html = new StringBuilder();
        String fieldName = template.getFieldName();
        if (!field.getTypeName().equals("multipleUser")) {
            SilverTrace.info("form", "UserFieldDisplayer.display", "form.INFO_NOT_CORRECT_TYPE", "multipleUser");
        } else {
            userIds = field.getStringValue();
        }
        if (!field.isNull()) {
            userNames = field.getValue();
        }
        html.append("<input type=\"hidden\" id=\"").append(fieldName).append("\" name=\"").append(fieldName).append("\" value=\"").append(EncodeHelper.javaStringToHtmlString(userIds)).append("\" />");
        String displayedElementId = fieldName + "_name";
        if (!template.isHidden()) {
            html.append("<textarea id=\"").append(displayedElementId).append("\" name=\"").append(fieldName).append("$$name\" disabled=\"disabled\" rows=\"").append(rows).append("\" cols=\"").append(cols).append("\">").append(EncodeHelper.javaStringToHtmlString(userNames)).append("</textarea>");
        }
        if (!(template.isHidden() || template.isDisabled() || template.isReadOnly())) {
            html.append("&nbsp;<a href=\"#\" onclick=\"javascript:SP_openWindow('").append(URLManager.getApplicationURL()).append("/RselectionPeasWrapper/jsp/open?formName=").append(pageContext.getFormName()).append("&elementId=").append(fieldName).append("&elementName=").append(displayedElementId).append("&selectedUsers=").append(userIds == null ? "" : userIds).append(usersOfInstanceOnly ? "&instanceId=" + pageContext.getComponentId() : "").append(StringUtil.isDefined(roles) ? "&roles=" + roles : "").append("&selectionMultiple=true").append("','selectUser',800,600,'');return false;\" >");
            html.append("<img src=\"").append(selectUserImg).append("\" width=\"15\" height=\"15\" border=\"0\" alt=\"").append(selectUserLab).append("\" align=\"absmiddle\" title=\"").append(selectUserLab).append("\"/></a>");
            if (template.isMandatory()) {
                html.append(Util.getMandatorySnippet());
            }
        }
        out.println(html.toString());
    }

    @Override
    public List<String> update(String newIds, MultipleUserField field, FieldTemplate template, PagesContext pagesContext) throws FormException {
        if ("multipleUser".equals(field.getTypeName())) {
            if (!StringUtil.isDefined(newIds)) {
                field.setNull();
            } else {
                field.setStringValue(newIds);
            }
        } else {
            throw new FormException("UserFieldDisplayer.update", "form.EX_NOT_CORRECT_VALUE", "user");
        }
        return new ArrayList<String>();
    }

    @Override
    public List<String> update(List<FileItem> items, MultipleUserField field, FieldTemplate template, PagesContext pageContext) throws FormException {
        String itemName = template.getFieldName();
        String value = FileUploadUtil.getParameter(items, itemName);
        if (pageContext.getUpdatePolicy() == 1 && !StringUtil.isDefined(value)) {
            return new ArrayList<String>();
        }
        return this.update(value, field, template, pageContext);
    }

    @Override
    public boolean isDisplayedMandatory() {
        return true;
    }

    @Override
    public int getNbHtmlObjectsDisplayed(FieldTemplate template, PagesContext pagesContext) {
        return 2;
    }
}

