/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.form.displayers;

import com.silverpeas.form.FieldTemplate;
import com.silverpeas.form.FormException;
import com.silverpeas.form.PagesContext;
import com.silverpeas.form.Util;
import com.silverpeas.form.displayers.AbstractTextFieldDisplayer;
import com.silverpeas.form.fieldType.TextField;
import com.silverpeas.form.fieldType.TextFieldImpl;
import com.silverpeas.util.EncodeHelper;
import com.silverpeas.util.StringUtil;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import java.io.PrintWriter;
import java.util.List;
import java.util.Map;
import org.apache.ecs.Element;
import org.apache.ecs.ElementContainer;
import org.apache.ecs.xhtml.img;
import org.apache.ecs.xhtml.input;

public class UrlFieldDisplayer
extends AbstractTextFieldDisplayer<TextField> {
    @Override
    public void display(PrintWriter out, TextField field, FieldTemplate template, PagesContext pageContext) throws FormException {
        String value;
        String defaultValue;
        String html = "";
        String fieldName = Util.getFieldOccurrenceName(template.getFieldName(), field.getOccurrence());
        SilverTrace.info("form", "UrlFieldDisplayer.display", "root.MSG_GEN_PARAM_VALUE", "fieldName=" + fieldName);
        Map<String, String> parameters = template.getParameters(pageContext.getLanguage());
        if (!field.getTypeName().equals("text")) {
            SilverTrace.info("form", "UrlFieldDisplayer.display", "form.INFO_NOT_CORRECT_TYPE", "text");
        }
        String string = defaultValue = parameters.containsKey("default") ? parameters.get("default") : "";
        if (pageContext.isIgnoreDefaultValues()) {
            defaultValue = "";
        }
        String string2 = value = !field.isNull() ? field.getValue(pageContext.getLanguage()) : defaultValue;
        if (pageContext.isBlankFieldsUse()) {
            value = "";
        }
        if (template.isReadOnly() && !template.isHidden()) {
            if (StringUtil.isDefined(value)) {
                if (!(value.startsWith("http") || value.startsWith("ftp:") || value.startsWith("/"))) {
                    value = "http://" + value;
                }
                html = "<a target=\"_blank\" href=\"" + value + "\">" + EncodeHelper.javaStringToHtmlString(value) + "</a>";
            }
        } else {
            String paramSuggestions = parameters.containsKey("suggestions") ? parameters.get("suggestions") : "false";
            boolean useSuggestions = Boolean.valueOf(paramSuggestions);
            List<String> suggestions = null;
            if (useSuggestions) {
                TextFieldImpl textField = (TextFieldImpl)field;
                suggestions = textField.getSuggestions(fieldName, template.getTemplateName(), pageContext.getComponentId());
            }
            input inputField = new input();
            inputField.setName(fieldName);
            inputField.setID(fieldName);
            inputField.setValue(EncodeHelper.javaStringToHtmlString(value));
            inputField.setType(template.isHidden() ? "hidden" : "text");
            inputField.setMaxlength(parameters.containsKey("maxLength") ? parameters.get("maxLength") : "1000");
            inputField.setSize(parameters.containsKey("size") ? parameters.get("size") : "50");
            if (parameters.containsKey("border")) {
                inputField.setBorder(Integer.parseInt(parameters.get("border")));
            }
            if (template.isDisabled()) {
                inputField.setDisabled(true);
            } else if (template.isReadOnly()) {
                inputField.setReadOnly(true);
            }
            img image = null;
            if (template.isMandatory() && !template.isDisabled() && !template.isReadOnly() && !template.isHidden() && pageContext.useMandatory()) {
                image = new img();
                image.setSrc(Util.getIcon("mandatoryField"));
                image.setWidth(5);
                image.setHeight(5);
                image.setBorder(0);
            }
            if (suggestions != null && suggestions.size() > 0) {
                TextFieldImpl.printSuggestionsIncludes(pageContext, fieldName, out);
                out.println("<div id=\"listAutocomplete" + fieldName + "\">\n");
                out.println(inputField.toString());
                out.println("<div id=\"container" + fieldName + "\"/>\n");
                out.println("</div>\n");
                if (image != null) {
                    image.setStyle("position:absolute;left:16em;top:5px");
                    out.println(image.toString());
                }
                TextFieldImpl.printSuggestionsScripts(pageContext, fieldName, suggestions, out);
            } else if (image != null) {
                ElementContainer container = new ElementContainer();
                container.addElement((Element)inputField);
                container.addElement("&nbsp;");
                container.addElement((Element)image);
                out.println(container.toString());
            } else {
                out.println(inputField.toString());
            }
        }
        out.println(html);
    }
}

