/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.form.fieldType;

import com.novell.ldap.LDAPAttribute;
import com.novell.ldap.LDAPConnection;
import com.novell.ldap.LDAPConstraints;
import com.novell.ldap.LDAPEntry;
import com.novell.ldap.LDAPException;
import com.novell.ldap.LDAPSearchConstraints;
import com.novell.ldap.LDAPSearchResults;
import com.silverpeas.form.FormException;
import com.silverpeas.form.fieldType.TextField;
import com.silverpeas.util.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import org.silverpeas.core.admin.OrganisationControllerFactory;

public class LdapField
extends TextField {
    private static final long serialVersionUID = 1L;
    public static final String TYPE = "ldap";
    public static final String VARIABLE_LOGIN = "$$login";
    private static final String VARIABLE_REGEX_LOGIN = "\\$\\$login";
    private String value = "";

    @Override
    public String getTypeName() {
        return TYPE;
    }

    @Override
    public String getStringValue() {
        return this.value;
    }

    @Override
    public void setStringValue(String value) {
        this.value = value;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    public LDAPConnection connectLdap(String host, String port) throws FormException {
        if (!StringUtil.isDefined(host) || !StringUtil.isDefined(port)) {
            throw new FormException("LdapField.connectLdap", "form.EX_CANT_CONNECT_LDAP");
        }
        try {
            LDAPConnection ldapConnection = new LDAPConnection();
            int portInt = Integer.parseInt(port);
            ldapConnection.connect(host, portInt);
            return ldapConnection;
        }
        catch (Exception e) {
            throw new FormException("LdapField.connectLdap", "form.EX_CANT_CONNECT_LDAP", e);
        }
    }

    public void disconnectLdap(LDAPConnection connection) throws FormException {
        try {
            if (connection != null && connection.isConnected()) {
                connection.disconnect();
            }
        }
        catch (Exception e) {
            throw new FormException("LdapField.disconnectLdap", "form.EX_CANT_DISCONNECT_LDAP", e);
        }
    }

    public void bindLdap(LDAPConnection ldapConnection, String version, String distinguishedName, byte[] password) throws FormException {
        if (!StringUtil.isDefined(version) || !StringUtil.isDefined(distinguishedName)) {
            throw new FormException("LdapField.bindLdap", "form.EX_CANT_BIND_LDAP");
        }
        try {
            int versionInt = Integer.parseInt(version);
            ldapConnection.bind(versionInt, distinguishedName, password);
        }
        catch (Exception e) {
            throw new FormException("LdapField.bindLdap", "form.EX_CANT_BIND_LDAP", e);
        }
    }

    public void setConstraintLdap(LDAPConnection ldapConnection, String maxResultDisplayed) throws FormException {
        try {
            int maxResultDisplayedInt = Integer.parseInt(maxResultDisplayed);
            LDAPSearchConstraints ldapConstraint = new LDAPSearchConstraints();
            ldapConstraint.setMaxResults(maxResultDisplayedInt);
            ldapConnection.setConstraints((LDAPConstraints)ldapConstraint);
        }
        catch (Exception e) {
            throw new FormException("LdapField.setConstraintLdap", "form.EX_CANT_SET_CONSTRAINT_LDAP", e);
        }
    }

    public Collection<String> searchLdap(LDAPConnection ldapConnection, String baseDn, String scope, String filter, String attribute, boolean typesOnly, String currentUserId) throws FormException {
        ArrayList<String> listRes = new ArrayList<String>();
        LDAPSearchResults searchResult = null;
        if (filter.contains(VARIABLE_LOGIN)) {
            try {
                String valueLogin = OrganisationControllerFactory.getOrganisationController().getUserDetail(currentUserId).getLogin();
                filter = filter.replaceAll(VARIABLE_REGEX_LOGIN, valueLogin);
            }
            catch (Exception e) {
                throw new FormException("LdapField.searchLdap", "form.EX_CANT_SEARCH_LDAP", "Can't get login of the currentUser", e);
            }
        }
        String[] tabSearchAttribute = null;
        try {
            int scopeInt = Integer.parseInt(scope);
            if (StringUtil.isDefined(attribute)) {
                tabSearchAttribute = new String[]{attribute};
            }
            searchResult = ldapConnection.search(baseDn, scopeInt, filter, tabSearchAttribute, typesOnly);
        }
        catch (Exception e) {
            throw new FormException("LdapField.searchLdap", "form.EX_CANT_SEARCH_LDAP", e);
        }
        if (searchResult != null) {
            String theValue = null;
            try {
                for (int nbReaded = 0; searchResult.hasMore() && ldapConnection.getSearchConstraints().getMaxResults() > nbReaded; ++nbReaded) {
                    LDAPEntry entry = searchResult.next();
                    if (tabSearchAttribute != null) {
                        LDAPAttribute ldapAttribute = entry.getAttribute(tabSearchAttribute[0]);
                        if (ldapAttribute == null) continue;
                        theValue = ldapAttribute.getStringValue();
                        continue;
                    }
                    theValue = entry.getDN();
                    if (!StringUtil.isDefined(theValue)) continue;
                    listRes.add(theValue);
                }
            }
            catch (LDAPException e) {
                throw new FormException("LdapField.searchLdap", "form.EX_CANT_SEARCH_LDAP", (Exception)((Object)e));
            }
        }
        return listRes;
    }
}

