/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.form.filter;

import com.silverpeas.form.DataRecord;
import com.silverpeas.form.Field;
import com.silverpeas.form.FieldTemplate;
import com.silverpeas.form.Form;
import com.silverpeas.form.FormException;
import com.silverpeas.form.RecordTemplate;
import com.silverpeas.form.Util;
import com.silverpeas.form.filter.EqualityFilter;
import com.silverpeas.form.filter.FieldFilter;
import com.silverpeas.form.filter.GreaterThenFilter;
import com.silverpeas.form.filter.LessThenFilter;
import com.silverpeas.form.filter.LikeFilter;
import com.silverpeas.form.filter.RecordFilter;
import com.silverpeas.form.filter.SimpleRecordFilter;
import com.silverpeas.form.form.XmlForm;
import com.silverpeas.form.record.GenericFieldTemplate;
import com.silverpeas.form.record.GenericRecordTemplate;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FilterManager {
    private final RecordTemplate template;
    private GenericRecordTemplate criteriaTemplate = null;
    private Form criteriaForm = null;
    private String lang = null;
    private Hashtable<String, FieldTemplate> fieldsParameter = new Hashtable();

    public FilterManager(RecordTemplate rowTemplate, String lang) {
        this.template = rowTemplate;
        this.lang = lang;
    }

    public Form getCriteriaForm() throws FormException {
        if (this.criteriaForm == null) {
            this.criteriaForm = new XmlForm(this.getCriteriaTemplate());
        }
        return this.criteriaForm;
    }

    public RecordTemplate getCriteriaTemplate() throws FormException {
        if (this.criteriaTemplate == null) {
            FieldTemplate[] filteredFields;
            this.criteriaTemplate = new GenericRecordTemplate();
            for (FieldTemplate filteredField : filteredFields = this.template.getFieldTemplates()) {
                Set<String> keys;
                Map<String, String> parameters;
                FieldTemplate field;
                GenericFieldTemplate criteriumField;
                String filteredType = filteredField.getTypeName();
                String filteredName = filteredField.getFieldName();
                String filteredLabel = filteredField.getLabel(this.lang);
                if ("text".equals(filteredType)) {
                    criteriumField = new GenericFieldTemplate(filteredName + "__like", "text");
                    criteriumField.addLabel(filteredLabel + " " + Util.getString("eq", this.lang), this.lang);
                    if (this.fieldsParameter.containsKey(filteredName)) {
                        field = this.fieldsParameter.get(filteredName);
                        criteriumField.setDisplayerName("listbox");
                        parameters = field.getParameters(this.lang);
                        keys = parameters.keySet();
                        for (String key : keys) {
                            criteriumField.addParameter(key, parameters.get(key));
                        }
                    }
                } else if ("jdbc".equals(filteredType)) {
                    criteriumField = new GenericFieldTemplate(filteredName + "__equal", filteredType);
                    criteriumField.addLabel(filteredLabel + " " + Util.getString("eq", this.lang), this.lang);
                    if (this.fieldsParameter.containsKey(filteredName)) {
                        field = this.fieldsParameter.get(filteredName);
                        parameters = field.getParameters(this.lang);
                        keys = parameters.keySet();
                        for (String key : keys) {
                            criteriumField.addParameter(key, parameters.get(key));
                        }
                        criteriumField.addParameter("displayer", "listbox");
                    }
                } else if ("date".equals(filteredType)) {
                    criteriumField = new GenericFieldTemplate(filteredName + "__lt", "date");
                    criteriumField.addLabel(filteredLabel + " " + Util.getString("le", this.lang), this.lang);
                    this.criteriaTemplate.addFieldTemplate(criteriumField);
                    criteriumField = new GenericFieldTemplate(filteredName + "__gt", "date");
                    criteriumField.addLabel(filteredLabel + " " + Util.getString("ge", this.lang), this.lang);
                } else {
                    criteriumField = new GenericFieldTemplate(filteredName + "__equal", filteredType);
                    criteriumField.addLabel(filteredLabel + " " + Util.getString("eq", this.lang), this.lang);
                }
                this.criteriaTemplate.addFieldTemplate(criteriumField);
            }
        }
        return this.criteriaTemplate;
    }

    public DataRecord getEmptyCriteriaRecord() throws FormException {
        return this.getCriteriaTemplate().getEmptyRecord();
    }

    public List<DataRecord> filter(DataRecord criteria, List<DataRecord> filtered) throws FormException {
        ArrayList<DataRecord> result = new ArrayList<DataRecord>();
        RecordFilter filter = this.buildRecordFilter(criteria);
        for (DataRecord record : filtered) {
            if (!filter.match(record)) continue;
            result.add(record);
        }
        return result;
    }

    public RecordFilter buildRecordFilter(DataRecord criteriaRecord) throws FormException {
        String[] criteriaNames;
        SimpleRecordFilter filter = new SimpleRecordFilter();
        for (String criteriaName : criteriaNames = this.getCriteriaTemplate().getFieldNames()) {
            Field criteria = criteriaRecord.getField(criteriaName);
            if (criteria.isNull()) continue;
            String filteredName = this.getFilteredName(criteriaName);
            String filterKind = this.getFilterKind(criteriaName);
            FieldFilter fieldFilter = "like".equals(filterKind) ? new LikeFilter(criteria) : ("lt".equals(filterKind) ? new LessThenFilter(criteria) : ("gt".equals(filterKind) ? new GreaterThenFilter(criteria) : ("equal".equals(filterKind) ? new EqualityFilter(criteria) : null)));
            if (fieldFilter == null) continue;
            filter.addFieldFilter(filteredName, fieldFilter);
        }
        return filter;
    }

    public void addFieldParameter(String fieldName, FieldTemplate field) {
        this.fieldsParameter.put(fieldName, field);
    }

    private String getFilteredName(String criteriaName) {
        int sep = criteriaName.lastIndexOf("__");
        if (sep == -1) {
            return criteriaName;
        }
        return criteriaName.substring(0, sep);
    }

    private String getFilterKind(String criteriaName) {
        int sep = criteriaName.lastIndexOf("__");
        if (sep == -1 || sep + 2 >= criteriaName.length()) {
            return "";
        }
        return criteriaName.substring(sep + 2);
    }
}

