/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.form.form;

import com.silverpeas.form.AbstractForm;
import com.silverpeas.form.DataRecord;
import com.silverpeas.form.Field;
import com.silverpeas.form.FieldDisplayer;
import com.silverpeas.form.FieldTemplate;
import com.silverpeas.form.FormException;
import com.silverpeas.form.PagesContext;
import com.silverpeas.form.RecordTemplate;
import com.silverpeas.form.record.GenericFieldTemplate;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import javax.servlet.jsp.JspWriter;
import org.silverpeas.util.Charsets;

public class HtmlForm
extends AbstractForm {
    private DataRecord record;
    private PagesContext pagesContext;
    private String m_FileName = null;
    private BufferedReader m_HtmlFile = null;
    private String currentLine = "";
    private static String TAG_BEGIN = "<%=";
    private static String TAG_END = "%>";

    public HtmlForm(RecordTemplate template) throws FormException {
        super(template);
    }

    public void setFileName(String fileName) {
        this.m_FileName = fileName;
    }

    private void closeHtmlFile() throws IOException {
        if (this.m_HtmlFile != null) {
            try {
                this.m_HtmlFile.close();
                this.m_HtmlFile = null;
            }
            catch (IOException e) {
                SilverTrace.error("form", "HtmlForm.closeHtmlFile", "form.EX_CANT_CLOSE_FILE", "fileName = [" + this.m_FileName + "]", e);
                throw e;
            }
        }
    }

    private void openHtmlFile() throws FileNotFoundException, IOException {
        this.closeHtmlFile();
        this.m_HtmlFile = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.m_FileName), Charsets.UTF_8));
    }

    private void parseFile(PrintWriter out) throws IOException, FileNotFoundException {
        this.openHtmlFile();
        PagesContext pc = new PagesContext(this.pagesContext);
        boolean endOfFile = false;
        pc.incCurrentFieldIndex(1);
        do {
            if (endOfFile = this.printBeforeTag(out)) continue;
            this.processTag(out, pc);
        } while (!endOfFile);
        this.closeHtmlFile();
    }

    private boolean printBeforeTag(PrintWriter out) throws IOException {
        if (this.currentLine == null || this.currentLine.isEmpty()) {
            this.currentLine = this.m_HtmlFile.readLine();
        }
        if (this.currentLine == null) {
            return true;
        }
        int pos = this.currentLine.indexOf(TAG_BEGIN);
        if (pos == -1) {
            out.println(this.currentLine);
            this.currentLine = "";
            return this.printBeforeTag(out);
        }
        out.println(this.currentLine.substring(0, pos));
        this.currentLine = this.currentLine.substring(pos, this.currentLine.length());
        return false;
    }

    private void processTag(PrintWriter out, PagesContext pc) throws IOException {
        if (this.currentLine == null || this.currentLine.isEmpty()) {
            this.currentLine = this.m_HtmlFile.readLine();
        }
        if (this.currentLine == null) {
            SilverTrace.error("form", "HtmlForm.processTag", "form.EX_END_OF_FILE");
            return;
        }
        int beginPos = this.currentLine.indexOf(TAG_BEGIN);
        if (beginPos != 0) {
            SilverTrace.error("form", "HtmlForm.processTag", "form.EX_TAG_NOT_FOUND");
            return;
        }
        int endPos = this.currentLine.indexOf(TAG_END);
        while (endPos == -1) {
            String newLine = this.m_HtmlFile.readLine();
            if (newLine == null) {
                SilverTrace.error("form", "HtmlForm.processTag", "form.EX_END_OF_FILE");
                return;
            }
            this.currentLine = this.currentLine + newLine;
            endPos = this.currentLine.indexOf(TAG_END);
        }
        String fieldName = this.currentLine.substring(beginPos + TAG_BEGIN.length(), endPos);
        if (fieldName.endsWith(".label")) {
            fieldName = fieldName.substring(0, fieldName.lastIndexOf("."));
            this.printFieldLabel(out, fieldName, pc);
        } else {
            this.printField(out, fieldName, pc);
        }
        this.currentLine = this.currentLine.substring(endPos + TAG_END.length(), this.currentLine.length());
    }

    private void printField(PrintWriter out, String fieldName, PagesContext pc) {
        try {
            Field field = this.record.getField(fieldName);
            String currentFieldName = fieldName;
            if (field != null) {
                boolean fieldFound = false;
                boolean workflowPrintForm = false;
                if (currentFieldName.indexOf(46) != -1) {
                    currentFieldName = currentFieldName.substring(currentFieldName.indexOf(46) + 1, currentFieldName.length());
                    workflowPrintForm = true;
                }
                for (FieldTemplate fieldTemplate : this.getFieldTemplates()) {
                    FieldDisplayer fieldDisplayer;
                    if (fieldTemplate == null || !fieldTemplate.getFieldName().equalsIgnoreCase(currentFieldName)) continue;
                    if (workflowPrintForm) {
                        ((GenericFieldTemplate)fieldTemplate).setDisplayerName("simpletext");
                        ((GenericFieldTemplate)fieldTemplate).setFieldName(fieldName);
                    }
                    if ((fieldDisplayer = this.getFieldDisplayer(fieldTemplate)) != null) {
                        if (!fieldTemplate.isRepeatable()) {
                            field = this.getSureField(fieldTemplate, this.record, 0);
                            fieldDisplayer.display(out, field, fieldTemplate, pc);
                        } else {
                            boolean isWriting = !"simpletext".equals(fieldTemplate.getDisplayerName()) && !fieldTemplate.isReadOnly();
                            int maxOccurrences = fieldTemplate.getMaximumNumberOfOccurrences();
                            out.println("<ul class=\"repeatable-field-list field_" + fieldName + "\">");
                            for (int occ = 0; occ < maxOccurrences; ++occ) {
                                field = this.getSureField(fieldTemplate, this.record, occ);
                                if (!this.pagesContext.isDesignMode() && !isWriting && occ != 0 && field.isNull()) continue;
                                if (occ != 0) {
                                    ((GenericFieldTemplate)fieldTemplate).setMandatory(false);
                                }
                                out.println("<li class=\"repeatable-field-list-element" + occ + "\">");
                                fieldDisplayer.display(out, field, fieldTemplate, pc);
                                out.println("</li>");
                            }
                            out.println("</ul>");
                        }
                    }
                    fieldFound = true;
                    break;
                }
                if (!fieldFound) {
                    out.print(field.getValue(pc.getLanguage()));
                }
            }
        }
        catch (FormException fe) {
            SilverTrace.error("form", "HtmlForm.display", "form.EXP_UNKNOWN_FIELD", fieldName);
        }
    }

    private void printFieldLabel(PrintWriter out, String fieldName, PagesContext pc) {
        fieldName = fieldName.substring(fieldName.indexOf(46) + 1, fieldName.length());
        for (FieldTemplate fieldTemplate : this.getFieldTemplates()) {
            if (fieldTemplate == null || !fieldTemplate.getFieldName().equalsIgnoreCase(fieldName)) continue;
            out.print(fieldTemplate.getLabel(pc.getLanguage()));
            break;
        }
    }

    @Override
    public void display(JspWriter jw, PagesContext pagesContext, DataRecord record) {
        try {
            jw.write(this.toString(pagesContext, record));
        }
        catch (IOException fe) {
            SilverTrace.error("form", "HtmlForm.display", "form.EXP_CANT_WRITE", null, fe);
        }
    }

    @Override
    public String toString(PagesContext PagesContext2, DataRecord record) {
        this.record = record;
        this.pagesContext = PagesContext2;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream(2048);
        try {
            PrintWriter out = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)buffer, Charsets.UTF_8), true);
            out.println("<input type=\"hidden\" name=\"id\" value=\"" + record.getId() + "\"/>");
            this.parseFile(out);
            out.flush();
        }
        catch (FileNotFoundException fe) {
            SilverTrace.error("form", "HtmlForm.toString", "form.EX_CANT_OPEN_FILE", null, fe);
        }
        catch (IOException fe) {
            SilverTrace.error("form", "HtmlForm.toString", "form.EXP_CANT_WRITE", null, fe);
        }
        return new String(buffer.toByteArray(), Charsets.UTF_8);
    }

    @Override
    public String getTitle() {
        return "";
    }
}

