/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.form.record;

import com.silverpeas.form.DataRecord;
import com.silverpeas.form.FieldTemplate;
import com.silverpeas.form.FormException;
import com.silverpeas.form.RecordTemplate;
import com.silverpeas.form.record.GenericDataRecord;
import com.silverpeas.form.record.GenericFieldTemplate;
import com.silverpeas.form.record.IndexedFieldTemplate;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="recordTemplate")
@XmlAccessorType(value=XmlAccessType.NONE)
public class GenericRecordTemplate
implements RecordTemplate,
Serializable {
    private static final long serialVersionUID = 5454875955919676819L;
    private Map<String, IndexedFieldTemplate> fields = new LinkedHashMap<String, IndexedFieldTemplate>();
    @XmlElement(name="fieldTemplate", type=GenericFieldTemplate.class)
    private List<FieldTemplate> fieldList = new ArrayList<FieldTemplate>();
    private String templateName;

    public List<FieldTemplate> getFieldList() {
        return this.fieldList;
    }

    public void setFieldList(List<FieldTemplate> fieldList) {
        this.fieldList = new ArrayList<FieldTemplate>(fieldList);
    }

    Map<String, IndexedFieldTemplate> getFields() {
        if (this.fields == null || this.fields.isEmpty()) {
            for (FieldTemplate aFieldList : this.fieldList) {
                GenericFieldTemplate field = (GenericFieldTemplate)aFieldList;
                field.setTemplateName(this.templateName);
                this.addFieldTemplate(field);
            }
        }
        return Collections.unmodifiableMap(this.fields);
    }

    public void addFieldTemplate(FieldTemplate fieldTemplate) {
        IndexedFieldTemplate indexed = new IndexedFieldTemplate(this.fields.size(), fieldTemplate);
        this.fields.put(fieldTemplate.getFieldName(), indexed);
    }

    @Override
    public String[] getFieldNames() {
        return this.getFields().keySet().toArray(new String[this.getFields().size()]);
    }

    @Override
    public FieldTemplate[] getFieldTemplates() {
        FieldTemplate[] fieldsArray = new FieldTemplate[this.getFields().keySet().size()];
        for (IndexedFieldTemplate field : this.getFields().values()) {
            fieldsArray[field.index] = field.fieldTemplate;
        }
        return fieldsArray;
    }

    @Override
    public FieldTemplate getFieldTemplate(String fieldName) throws FormException {
        IndexedFieldTemplate indexed = this.getFields().get(fieldName);
        if (indexed == null) {
            throw new FormException("GenericRecordTemplate", "form.EXP_UNKNOWN_FIELD", fieldName);
        }
        return indexed.fieldTemplate;
    }

    @Override
    public int getFieldIndex(String fieldName) throws FormException {
        IndexedFieldTemplate indexed = this.getFields().get(fieldName);
        if (indexed == null) {
            throw new FormException("GenericRecordTemplate", "form.EXP_UNKNOWN_FIELD", fieldName);
        }
        return indexed.index;
    }

    @Override
    public DataRecord getEmptyRecord() throws FormException {
        return new GenericDataRecord(this);
    }

    @Override
    public boolean checkDataRecord(DataRecord record) {
        return true;
    }

    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }
}

