/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.jcrutil;

import com.silverpeas.util.StringUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PreDestroy;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.apache.commons.io.FileUtils;
import org.apache.jackrabbit.api.JackrabbitRepository;
import org.apache.jackrabbit.core.RepositoryImpl;
import org.apache.jackrabbit.core.config.RepositoryConfig;
import org.apache.jackrabbit.core.jndi.RegistryHelper;
import org.silverpeas.util.Charsets;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springmodules.jcr.RepositoryFactoryBean;
import org.xml.sax.InputSource;

public class BetterRepositoryFactoryBean
extends RepositoryFactoryBean {
    private boolean useSystemProperties = false;
    private static final String DEFAULT_CONF_FILE = "repository.xml";
    private static final String DEFAULT_REP_DIR = ".";
    private List<String> configurationProperties;
    private Resource homeDir;
    private RepositoryConfig repositoryConfig;
    private String jndiName;

    protected Repository createRepository() throws Exception {
        if (StringUtil.isDefined(this.jndiName)) {
            return this.createJndiRepository(this.jndiName);
        }
        return RepositoryImpl.create((RepositoryConfig)this.repositoryConfig);
    }

    protected Repository createJndiRepository(String jndiName) {
        try {
            InitialContext ic = new InitialContext();
            BetterRepositoryFactoryBean.prepareContext(ic, jndiName);
            RegistryHelper.registerRepository((Context)new InitialContext(), (String)jndiName, (String)this.getConfiguration().getFile().getAbsolutePath(), (String)this.getHomeDir().getFile().getAbsolutePath(), (boolean)true);
            return (Repository)ic.lookup(jndiName);
        }
        catch (RepositoryException ex) {
            Logger.getLogger(BetterRepositoryFactoryBean.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(BetterRepositoryFactoryBean.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (NamingException ex) {
            Logger.getLogger(BetterRepositoryFactoryBean.class.getName()).log(Level.SEVERE, null, ex);
        }
        return null;
    }

    protected static void prepareContext(InitialContext ic, String jndiName) throws NamingException {
        Context currentContext = ic;
        StringTokenizer tokenizer = new StringTokenizer(jndiName, "/", false);
        while (tokenizer.hasMoreTokens()) {
            String name = tokenizer.nextToken();
            if (!tokenizer.hasMoreTokens()) continue;
            try {
                currentContext = (Context)currentContext.lookup(name);
            }
            catch (NameNotFoundException nnfex) {
                currentContext = currentContext.createSubcontext(name);
            }
        }
    }

    protected void resolveConfigurationResource() throws Exception {
        if (this.repositoryConfig != null) {
            return;
        }
        if (this.configuration == null) {
            this.log.debug((Object)"no configuration resource specified, using the default one:repository.xml");
            this.configuration = new ClassPathResource(DEFAULT_CONF_FILE);
        }
        if (this.homeDir == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"no repository home dir specified, using the default one:.");
            }
            this.homeDir = new FileSystemResource(DEFAULT_REP_DIR);
        }
        if (this.getConfigurationProperties() != null) {
            String goodConfig = BetterRepositoryFactoryBean.replaceVariables(this.loadConfigurationKeys(), this.getConfiguration(this.configuration), true);
            this.repositoryConfig = RepositoryConfig.create((InputSource)new InputSource(new StringReader(goodConfig)), (String)this.homeDir.getFile().getAbsolutePath());
        } else {
            this.repositoryConfig = RepositoryConfig.create((InputSource)new InputSource(this.configuration.getInputStream()), (String)this.homeDir.getFile().getAbsolutePath());
        }
    }

    public static String replaceVariables(Properties variables, String value, boolean ignoreMissing) throws IllegalArgumentException {
        StringBuilder result = new StringBuilder();
        int p = 0;
        int q = value.indexOf("${");
        while (q != -1) {
            result.append(value.substring(p, q));
            p = q;
            if ((q = value.indexOf(125, q + 2)) == -1) continue;
            String variable = value.substring(p + 2, q);
            String replacement = variables.getProperty(variable);
            if (replacement == null) {
                if (ignoreMissing) {
                    replacement = "${" + variable + '}';
                } else {
                    throw new IllegalArgumentException("Replacement not found for ${" + variable + "}.");
                }
            }
            result.append(replacement);
            p = q + 1;
            q = value.indexOf("${", p);
        }
        result.append(value.substring(p, value.length()));
        return result.toString();
    }

    @PreDestroy
    public void destroy() throws Exception {
        this.log.info((Object)"Shutdown the JCR repository...");
        if (this.repository instanceof JackrabbitRepository) {
            ((JackrabbitRepository)this.repository).shutdown();
        }
        super.destroy();
    }

    public void testCleanUp() throws IOException {
        if (this.repository instanceof JackrabbitRepository) {
            ((JackrabbitRepository)this.repository).shutdown();
        }
        FileUtils.deleteQuietly((File)this.homeDir.getFile());
    }

    public Resource getHomeDir() {
        return this.homeDir;
    }

    public void setHomeDir(Resource defaultRepDir) {
        this.homeDir = defaultRepDir;
    }

    public RepositoryConfig getRepositoryConfig() {
        return this.repositoryConfig;
    }

    public void setRepositoryConfig(RepositoryConfig repositoryConfig) {
        this.repositoryConfig = repositoryConfig;
    }

    public List<String> getConfigurationProperties() {
        return this.configurationProperties;
    }

    public void setConfigurationProperties(List<String> resources) {
        this.configurationProperties = resources;
    }

    public String getJndiName() {
        return this.jndiName;
    }

    public void setJndiName(String jndiName) {
        this.jndiName = jndiName;
    }

    public boolean isUseSystemProperties() {
        return this.useSystemProperties;
    }

    public void setUseSystemProperties(boolean useSystemProperties) {
        this.useSystemProperties = useSystemProperties;
    }

    protected Properties loadConfigurationKeys() {
        Iterator<String> iter = this.configurationProperties.iterator();
        Properties props = this.isUseSystemProperties() ? new Properties(System.getProperties()) : new Properties();
        DefaultResourceLoader loader = new DefaultResourceLoader(((Object)((Object)this)).getClass().getClassLoader());
        String location = "";
        while (iter.hasNext()) {
            try {
                location = iter.next();
                props.load(loader.getResource(location).getInputStream());
            }
            catch (IOException e) {
                this.log.info((Object)("Error loading resource " + location), (Throwable)e);
            }
        }
        return props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getConfiguration(Resource config) throws IOException {
        StringWriter out = new StringWriter();
        Reader reader = null;
        try {
            int c;
            reader = new InputStreamReader(config.getInputStream(), Charsets.UTF_8);
            char[] buffer = new char[8];
            while ((c = reader.read(buffer)) > 0) {
                out.write(buffer, 0, c);
            }
            String string = out.toString();
            return string;
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }
}

