/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.jcrutil;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.jackrabbit.webdav.util.EncodeUtil;
import org.silverpeas.cache.service.CacheService;
import org.silverpeas.cache.service.CacheServiceFactory;

public class SilverpeasJcrWebdavContext {
    static final String WEBDAV_JCR_URL_SUFFIX = "webdav-jcr-url-suffix-";
    private static final Pattern TOKEN_PATTERN = Pattern.compile(".*/webdav/([a-zA-Z0-9]{16}+).*");
    private final String documentUrlLocation;
    private final String webDavUrl;
    private final String token;

    public static void clearFromToken(String token) {
        SilverpeasJcrWebdavContext.getCacheService().remove(WEBDAV_JCR_URL_SUFFIX + token);
    }

    public static SilverpeasJcrWebdavContext createWebdavContext(String jcrDocumentUrlLocation, String token) {
        String fileName = EncodeUtil.escape((String)jcrDocumentUrlLocation.replaceFirst("^.*/", ""));
        String webdavUrlSuffix = jcrDocumentUrlLocation.replaceFirst("^.*/webdav/", "").replaceFirst("[^/]*$", "") + fileName;
        SilverpeasJcrWebdavContext.getCacheService().put(WEBDAV_JCR_URL_SUFFIX + token, webdavUrlSuffix);
        String webdavUrl = jcrDocumentUrlLocation.replaceFirst("/webdav/.*", "/webdav/" + token + "/" + fileName);
        return new SilverpeasJcrWebdavContext(jcrDocumentUrlLocation, token, webdavUrl);
    }

    public static SilverpeasJcrWebdavContext getWebdavContext(String webDavUrl) {
        String token = "";
        String clearedWebdavUrl = webDavUrl;
        Matcher tokenMatcher = TOKEN_PATTERN.matcher(webDavUrl);
        if (tokenMatcher.matches()) {
            token = tokenMatcher.group(1);
        }
        if (!token.isEmpty()) {
            clearedWebdavUrl = clearedWebdavUrl.replace("/webdav/" + token, "/webdav");
            boolean webdavUrlContainsFileName = clearedWebdavUrl.matches(".*/webdav/.+");
            clearedWebdavUrl = clearedWebdavUrl.replaceFirst("/webdav.*$", "/webdav/") + SilverpeasJcrWebdavContext.getCacheService().get(WEBDAV_JCR_URL_SUFFIX + token, String.class);
            if (!webdavUrlContainsFileName) {
                clearedWebdavUrl = clearedWebdavUrl.replaceFirst("/[^/]*$", "");
                if (webDavUrl.endsWith("/")) {
                    clearedWebdavUrl = clearedWebdavUrl + "/";
                }
            }
        }
        return new SilverpeasJcrWebdavContext(clearedWebdavUrl, token, webDavUrl);
    }

    private SilverpeasJcrWebdavContext(String documentUrlLocation, String token, String webDavUrl) {
        this.documentUrlLocation = documentUrlLocation;
        this.webDavUrl = webDavUrl;
        this.token = token;
    }

    public String getJcrDocumentUrlLocation() {
        return this.documentUrlLocation;
    }

    public String getWebDavUrl() {
        return this.webDavUrl;
    }

    public String getToken() {
        return this.token;
    }

    private static CacheService getCacheService() {
        return CacheServiceFactory.getApplicationCacheService();
    }
}

