/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.notification.builder;

import com.silverpeas.notification.SilverpeasNotification;
import com.silverpeas.util.StringUtil;
import com.stratelia.silverpeas.notificationManager.NotificationManagerSettings;
import javax.servlet.http.HttpServletRequest;
import org.silverpeas.cache.service.CacheServiceFactory;

public class UserSubscriptionNotificationSendingHandler {
    private static final String SENDING_NOT_ENABLED_KEY = UserSubscriptionNotificationSendingHandler.class.getName() + "#SENDING_ENABLED";
    private static final String SENDING_NOT_ENABLED_JMS_WAY_KEY = UserSubscriptionNotificationSendingHandler.class.getName() + "#SENDING_ENABLED_JMS_WAY";

    public static void setupSilverpeasNotification(SilverpeasNotification silverpeasNotification) {
        if (!UserSubscriptionNotificationSendingHandler.isEnabledForCurrentRequest()) {
            silverpeasNotification.addParameter("SKIP_SUBSCRIPTION_NOTIFICATION_SENDING", "true");
        }
    }

    public static void verifySilverpeasNotification(SilverpeasNotification silverpeasNotification) {
        if (NotificationManagerSettings.isSubscriptionNotificationConfirmationEnabled() && StringUtil.getBooleanValue(silverpeasNotification.getParameterValue("SKIP_SUBSCRIPTION_NOTIFICATION_SENDING"))) {
            CacheServiceFactory.getThreadCacheService().put(SENDING_NOT_ENABLED_JMS_WAY_KEY, true);
        } else {
            CacheServiceFactory.getThreadCacheService().remove(SENDING_NOT_ENABLED_JMS_WAY_KEY);
        }
    }

    public static void verifyRequest(HttpServletRequest request) {
        if (NotificationManagerSettings.isSubscriptionNotificationConfirmationEnabled()) {
            boolean fromParameters = StringUtil.getBooleanValue(request.getParameter("SKIP_SUBSCRIPTION_NOTIFICATION_SENDING"));
            boolean fromHeaders = StringUtil.getBooleanValue(request.getHeader("SKIP_SUBSCRIPTION_NOTIFICATION_SENDING"));
            if (fromParameters || fromHeaders) {
                CacheServiceFactory.getRequestCacheService().put(SENDING_NOT_ENABLED_KEY, true);
            }
        }
    }

    public static boolean isEnabledForCurrentRequest() {
        Boolean notEnabled = CacheServiceFactory.getRequestCacheService().get(SENDING_NOT_ENABLED_KEY, Boolean.class);
        if (notEnabled == null) {
            notEnabled = CacheServiceFactory.getThreadCacheService().get(SENDING_NOT_ENABLED_JMS_WAY_KEY, Boolean.class);
        }
        return notEnabled == null || notEnabled == false;
    }
}

