/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.notification.delayed.constant;

import java.util.ArrayList;
import java.util.Collection;

public enum DelayedNotificationFrequency {
    NONE("N"),
    DAILY("D"),
    WEEKLY("W"),
    MONTHLY("M");

    private String code;

    private DelayedNotificationFrequency(String code) {
        this.code = code;
    }

    public String getCode() {
        return this.code;
    }

    public String getName() {
        return this.name();
    }

    public String toString() {
        return this.code;
    }

    public static DelayedNotificationFrequency decode(String code) {
        DelayedNotificationFrequency result = null;
        if (code != null) {
            if (DelayedNotificationFrequency.NONE.code.equals(code = code.trim())) {
                result = NONE;
            } else if (DelayedNotificationFrequency.DAILY.code.equals(code)) {
                result = DAILY;
            } else if (DelayedNotificationFrequency.WEEKLY.code.equals(code)) {
                result = WEEKLY;
            } else if (DelayedNotificationFrequency.MONTHLY.code.equals(code)) {
                result = MONTHLY;
            }
        }
        return result;
    }

    public static Collection<String> toCodes(Collection<DelayedNotificationFrequency> delayedNotificationFrequencies) {
        ArrayList<String> result = new ArrayList<String>();
        if (delayedNotificationFrequencies != null) {
            for (DelayedNotificationFrequency delayedNotificationFrequency : delayedNotificationFrequencies) {
                result.add(delayedNotificationFrequency.getCode());
            }
        }
        return result;
    }
}

