/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.notification.delayed.delegate;

import com.silverpeas.notification.delayed.DelayedNotificationFactory;
import com.silverpeas.notification.delayed.constant.DelayedNotificationFrequency;
import com.silverpeas.notification.delayed.model.DelayedNotificationData;
import com.silverpeas.notification.delayed.model.DelayedNotificationUserSetting;
import com.silverpeas.notification.delayed.synthese.DelayedNotificationSyntheseData;
import com.silverpeas.notification.delayed.synthese.SyntheseResource;
import com.silverpeas.notification.delayed.synthese.SyntheseResourceNotification;
import com.silverpeas.notification.model.NotificationResourceData;
import com.silverpeas.util.CollectionUtil;
import com.silverpeas.util.EncodeHelper;
import com.silverpeas.util.MapUtil;
import com.silverpeas.util.comparator.AbstractComplexComparator;
import com.silverpeas.util.template.SilverpeasTemplate;
import com.silverpeas.util.template.SilverpeasTemplateFactory;
import com.stratelia.silverpeas.notificationManager.AbstractNotification;
import com.stratelia.silverpeas.notificationManager.constant.NotifChannel;
import com.stratelia.silverpeas.notificationserver.NotificationData;
import com.stratelia.silverpeas.notificationserver.NotificationServer;
import com.stratelia.silverpeas.notificationserver.NotificationServerException;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.beans.admin.AdminReference;
import com.stratelia.webactiv.beans.admin.UserDetail;
import com.stratelia.webactiv.util.DateUtil;
import com.stratelia.webactiv.util.ResourceLocator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class DelayedNotificationDelegate
extends AbstractNotification {
    private static final String LOCATION_SEPARATOR = " &gt; ";
    private final Map<String, ResourceLocator> multilang = new HashMap<String, ResourceLocator>();
    private final NotificationServer notificationServer = new NotificationServer();
    private static final int MAX_USER_DETAIL_ITEMS = 100;
    private final Map<Integer, UserDetail> userDetailCache = new LinkedHashMap<Integer, UserDetail>(100);
    private SilverpeasTemplate template = null;
    private Comparator<NotificationResourceData> resourceComparator;
    private Comparator<DelayedNotificationData> delayedNotificationComparator;

    protected DelayedNotificationDelegate() {
    }

    public static void executeUserDeleting(int userId) throws Exception {
        DelayedNotificationDelegate.executeForceDelayedNotificationsSending(userId, DelayedNotificationFactory.getDelayedNotification().getWiredChannels());
        for (NotifChannel channel : DelayedNotificationFactory.getDelayedNotification().getWiredChannels()) {
            DelayedNotificationUserSetting settings = DelayedNotificationFactory.getDelayedNotification().getDelayedNotificationUserSettingByUserIdAndChannel(userId, channel);
            if (settings == null) continue;
            DelayedNotificationFactory.getDelayedNotification().deleteDelayedNotificationUserSetting(settings);
        }
    }

    public static DelayedNotificationUserSetting executeUserSettingsUpdating(int userId, NotifChannel channel, DelayedNotificationFrequency frequency) throws Exception {
        DelayedNotificationUserSetting result = null;
        DelayedNotificationUserSetting oldSettings = DelayedNotificationFactory.getDelayedNotification().getDelayedNotificationUserSettingByUserIdAndChannel(userId, channel);
        if (frequency != null) {
            result = DelayedNotificationFactory.getDelayedNotification().saveDelayedNotificationUserSetting(userId, channel, frequency);
        } else if (oldSettings != null) {
            DelayedNotificationFactory.getDelayedNotification().deleteDelayedNotificationUserSetting(oldSettings);
        }
        if (oldSettings == null && frequency != null || oldSettings != null && !oldSettings.getFrequency().equals((Object)frequency)) {
            DelayedNotificationDelegate.executeForceDelayedNotificationsSending(userId, Collections.singleton(channel));
        }
        return result;
    }

    public static void executeNewNotification(DelayedNotificationData delayedNotificationData) throws Exception {
        new DelayedNotificationDelegate().performNewNotificationSending(delayedNotificationData);
    }

    protected void performNewNotificationSending(DelayedNotificationData delayedNotificationData) throws Exception {
        if (!this.isThatToBeDelayed(delayedNotificationData)) {
            this.sendNotification(delayedNotificationData.getNotificationData());
        } else {
            DelayedNotificationFactory.getDelayedNotification().saveDelayedNotification(delayedNotificationData);
        }
    }

    private boolean isThatToBeDelayed(DelayedNotificationData delayedNotificationData) {
        if (delayedNotificationData.isSendImmediately()) {
            return false;
        }
        if (delayedNotificationData.getAction() == null) {
            return false;
        }
        if (0 != delayedNotificationData.getNotificationParameters().iMessagePriority) {
            return false;
        }
        if (DelayedNotificationFrequency.NONE.equals((Object)DelayedNotificationFactory.getDelayedNotification().getUserFrequency(delayedNotificationData.getUserId(), delayedNotificationData.getChannel()))) {
            return false;
        }
        return delayedNotificationData.isValid();
    }

    public static void executeDelayedNotificationsSending(Date date) throws Exception {
        new DelayedNotificationDelegate().performDelayedNotificationsSending(date, DelayedNotificationFactory.getDelayedNotification().getWiredChannels());
    }

    public static void executeForceDelayedNotificationsSending() throws Exception {
        new DelayedNotificationDelegate().forceDelayedNotificationsSending();
    }

    public static void executeForceDelayedNotificationsSending(int userId, Set<NotifChannel> channels) throws Exception {
        DelayedNotificationDelegate.executeForceDelayedNotificationsSending(Collections.singletonList(userId), channels);
    }

    public static void executeForceDelayedNotificationsSending(List<Integer> userIds, Set<NotifChannel> channels) throws Exception {
        new DelayedNotificationDelegate().forceDelayedNotificationsSending(userIds, channels);
    }

    protected void forceDelayedNotificationsSending() throws Exception {
        List<Integer> usersToBeNotified = DelayedNotificationFactory.getDelayedNotification().findAllUsersToBeNotified(DelayedNotificationFactory.getDelayedNotification().getWiredChannels());
        this.forceDelayedNotificationsSending(usersToBeNotified, DelayedNotificationFactory.getDelayedNotification().getWiredChannels());
    }

    protected void forceDelayedNotificationsSending(List<Integer> userIds, Set<NotifChannel> channels) throws Exception {
        this.performUsersDelayedNotifications(userIds, channels);
    }

    protected void performDelayedNotificationsSending(Date date, Set<NotifChannel> channels) throws Exception {
        List<Integer> usersToBeNotified = DelayedNotificationFactory.getDelayedNotification().findUsersToBeNotified(date, channels, DelayedNotificationFactory.getDelayedNotification().getDefaultDelayedNotificationFrequency());
        this.performUsersDelayedNotifications(usersToBeNotified, channels);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performUsersDelayedNotifications(List<Integer> usersToBeNotified, Set<NotifChannel> channels) throws Exception {
        if (CollectionUtil.isEmpty(usersToBeNotified)) {
            return;
        }
        ArrayList<Long> delayedNotificationIdsToDelete = new ArrayList<Long>();
        try {
            for (Integer userIdToNotify : usersToBeNotified) {
                Map<NotifChannel, List<DelayedNotificationData>> delayedNotifications = DelayedNotificationFactory.getDelayedNotification().findDelayedNotificationByUserIdGroupByChannel(userIdToNotify, channels);
                for (Map.Entry<NotifChannel, List<DelayedNotificationData>> mapEntry : delayedNotifications.entrySet()) {
                    delayedNotificationIdsToDelete.addAll(this.performUserDelayedNotificationsOnChannel(mapEntry.getKey(), mapEntry.getValue()));
                }
            }
        }
        finally {
            DelayedNotificationFactory.getDelayedNotification().deleteDelayedNotifications(delayedNotificationIdsToDelete);
        }
    }

    private Collection<Long> performUserDelayedNotificationsOnChannel(NotifChannel channel, List<DelayedNotificationData> delayedNotifications) throws Exception {
        DelayedNotificationSyntheseData synthese = this.buildSynthese(delayedNotifications);
        this.sendNotification(this.createNotificationData(channel, synthese));
        return synthese.getDelayedNotificationIdProceeded();
    }

    private DelayedNotificationSyntheseData buildSynthese(List<DelayedNotificationData> delayedNotifications) throws Exception {
        DelayedNotificationSyntheseData synthese = this.initializeSynthese(delayedNotifications);
        HashMap resourcesAndNotifications = new HashMap();
        for (DelayedNotificationData delayedNotificationData : delayedNotifications) {
            MapUtil.putAddList(resourcesAndNotifications, delayedNotificationData.getResource(), delayedNotificationData);
        }
        ArrayList orderedResources = new ArrayList(resourcesAndNotifications.keySet());
        Collections.sort(orderedResources, this.getResourceComparator());
        for (NotificationResourceData resource : orderedResources) {
            this.prepareSyntheseResourceAndNotifications(synthese, resource, (List)resourcesAndNotifications.get(resource));
        }
        synthese.setMessage(this.buildMessage(synthese));
        return synthese;
    }

    private void prepareSyntheseResourceAndNotifications(DelayedNotificationSyntheseData synthese, NotificationResourceData resource, List<DelayedNotificationData> notifications) throws Exception {
        Collections.sort(notifications, this.getDelayedNotificationComparator());
        SyntheseResource syntheseResource = new SyntheseResource();
        synthese.addResource(syntheseResource);
        synthese.addNbNotifications(notifications.size());
        syntheseResource.setName(resource.getResourceName());
        syntheseResource.setDescription(resource.getResourceDescription());
        if (syntheseResource.getDescription() != null) {
            syntheseResource.setDescription(EncodeHelper.convertWhiteSpacesForHTMLDisplay(syntheseResource.getDescription()));
        }
        syntheseResource.setLocation(resource.getResourceLocation().replaceAll("@#@#@", LOCATION_SEPARATOR));
        syntheseResource.setUrl(resource.getResourceUrl());
        if (syntheseResource.getUrl() != null) {
            syntheseResource.setUrl(this.computeURL(synthese.getUserId(), syntheseResource.getUrl()));
        }
        boolean isPreviousHasMessage = false;
        for (DelayedNotificationData delayedNotificationData : notifications) {
            SyntheseResourceNotification syntheseNotification = new SyntheseResourceNotification();
            syntheseResource.addNotification(syntheseNotification);
            syntheseNotification.setAction(this.getStringTranslation("resourceAction" + delayedNotificationData.getAction().name(), synthese.getLanguage()));
            syntheseNotification.setFromUserName(this.getUserDetail(delayedNotificationData.getFromUserId()).getDisplayedName());
            syntheseNotification.setDate(DateUtil.getOutputDate(delayedNotificationData.getCreationDate(), synthese.getLanguage()));
            syntheseNotification.setTime(DateUtil.getOutputHour(delayedNotificationData.getCreationDate(), synthese.getLanguage()));
            syntheseNotification.setMessage(DelayedNotificationDelegate.nullIfBlank(delayedNotificationData.getMessage()));
            syntheseNotification.setPreviousHasMessage(isPreviousHasMessage);
            if (syntheseNotification.getMessage() != null) {
                isPreviousHasMessage = true;
                syntheseNotification.setMessage(EncodeHelper.convertWhiteSpacesForHTMLDisplay(syntheseNotification.getMessage()));
            } else {
                isPreviousHasMessage = false;
            }
            synthese.getDelayedNotificationIdProceeded().add(delayedNotificationData.getId());
        }
    }

    private static String nullIfBlank(String string) {
        return StringUtils.isBlank((CharSequence)string) ? null : string;
    }

    private String buildMessage(DelayedNotificationSyntheseData synthese) throws Exception {
        this.clearTemplate();
        this.getTemplate().setAttribute("delay", this.getStringTranslation("delay" + synthese.getFrequency().name(), synthese.getLanguage()));
        this.getTemplate().setAttribute("userName", this.getUserDetail(synthese.getUserId()).getDisplayedName());
        this.getTemplate().setAttribute("nbResources", synthese.getNbResources());
        this.getTemplate().setAttribute("severalResources", synthese.getNbResources() > 1);
        this.getTemplate().setAttribute("nbNotifications", synthese.getNbNotifications());
        this.getTemplate().setAttribute("severalNotifications", synthese.getNbNotifications() > 1);
        this.getTemplate().setAttribute("resources", synthese.getResources());
        return this.getTemplate().applyFileTemplate("messageLayout_" + synthese.getLanguage());
    }

    private String buildSubject(DelayedNotificationSyntheseData synthese) {
        this.clearTemplate();
        this.getTemplate().setAttribute("frequency", this.getStringTranslation("frequency" + synthese.getFrequency().name(), synthese.getLanguage()));
        return this.getTemplate().applyFileTemplate("subject_" + synthese.getLanguage());
    }

    private void clearTemplate() {
        this.getTemplate().getAttributes().clear();
    }

    private SilverpeasTemplate getTemplate() {
        if (this.template == null) {
            this.template = SilverpeasTemplateFactory.createSilverpeasTemplateOnCore("notification/delayed");
        }
        return this.template;
    }

    private DelayedNotificationSyntheseData initializeSynthese(List<DelayedNotificationData> delayedNotifications) {
        DelayedNotificationSyntheseData synthese = new DelayedNotificationSyntheseData();
        DelayedNotificationData first = delayedNotifications.get(0);
        synthese.setUserId(first.getUserId());
        synthese.setFrequency(DelayedNotificationFactory.getDelayedNotification().getUserFrequency(first.getUserId(), first.getChannel()));
        synthese.setLanguage(first.getLanguage());
        synthese.setSubject(this.buildSubject(synthese));
        return synthese;
    }

    private NotificationData createNotificationData(NotifChannel channel, DelayedNotificationSyntheseData synthese) throws Exception {
        NotificationData notificationData = new NotificationData();
        UserDetail receiver = this.getUserDetail(synthese.getUserId());
        UserDetail sender = this.getUserDetail(-1);
        SilverTrace.info("delayedNotificationDelegate", "DelayedNotificationDelegate.createNotificationData()", "root.MSG_GEN_PARAM_VALUE", "userId =" + synthese.getUserId());
        notificationData.setTargetChannel(channel.name());
        notificationData.setTargetReceipt(NotifChannel.SMTP.equals((Object)channel) ? receiver.geteMail() : Integer.toString(synthese.getUserId()));
        notificationData.setSenderName(sender.getDisplayedName());
        notificationData.setTargetParam(new HashMap<String, Object>());
        notificationData.getTargetParam().put("FROM", NotifChannel.SMTP.equals((Object)channel) ? sender.geteMail() : sender.getId());
        notificationData.getTargetParam().put("SUBJECT", synthese.getSubject());
        notificationData.getTargetParam().put("DATE", new Date());
        notificationData.getTargetParam().put("LANGUAGE", synthese.getLanguage());
        notificationData.getTargetParam().put("HIDESMTPHEADERFOOTER", true);
        notificationData.setMessage(synthese.getMessage());
        notificationData.setAnswerAllowed(false);
        return notificationData;
    }

    private String getStringTranslation(String key, String language) {
        ResourceLocator rl = this.multilang.get(language);
        if (rl == null) {
            rl = new ResourceLocator("com.stratelia.silverpeas.notificationManager.multilang.notificationManagerBundle", language);
            this.multilang.put(language, rl);
        }
        return rl.getString(key, null);
    }

    private Comparator<NotificationResourceData> getResourceComparator() {
        if (this.resourceComparator == null) {
            this.resourceComparator = new AbstractComplexComparator<NotificationResourceData>(){

                @Override
                protected AbstractComplexComparator.ValueBuffer getValuesToCompare(NotificationResourceData object) {
                    return new AbstractComplexComparator.ValueBuffer(this).append(object.getResourceLocation()).append(object.getResourceType()).append(object.getResourceName()).append(object.getResourceDescription()).append(object.getComponentInstanceId());
                }
            };
        }
        return this.resourceComparator;
    }

    private Comparator<DelayedNotificationData> getDelayedNotificationComparator() {
        if (this.delayedNotificationComparator == null) {
            this.delayedNotificationComparator = new AbstractComplexComparator<DelayedNotificationData>(){

                @Override
                protected AbstractComplexComparator.ValueBuffer getValuesToCompare(DelayedNotificationData object) {
                    return new AbstractComplexComparator.ValueBuffer(this).append(object.getCreationDate()).append(object.getAction().getPriority());
                }
            };
        }
        return this.delayedNotificationComparator;
    }

    protected UserDetail getUserDetail(Integer userId) throws Exception {
        UserDetail userDetail = this.userDetailCache.get(userId);
        if (userDetail == null) {
            if (userId >= 0) {
                userDetail = AdminReference.getAdminService().getUserDetail(Integer.toString(userId));
            } else {
                userDetail = new UserDetail();
                userDetail.setId(Integer.toString(userId));
                userDetail.seteMail(AdminReference.getAdminService().getAdministratorEmail());
            }
            if (this.userDetailCache.size() >= 100) {
                this.userDetailCache.remove(this.userDetailCache.keySet().iterator().next());
            }
            this.userDetailCache.put(userId, userDetail);
        }
        return userDetail;
    }

    protected void sendNotification(NotificationData notificationData) throws NotificationServerException {
        notificationData.setMessage(notificationData.getMessage().replaceAll("[\r\n\t]", ""));
        this.notificationServer.addNotification(notificationData);
    }
}

