/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.personalization;

import com.silverpeas.personalization.UserMenuDisplay;
import com.silverpeas.util.StringUtil;
import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;

@Entity
@Table(name="personalization")
public class UserPreferences
implements Serializable {
    private static final long serialVersionUID = 9192830552642027995L;
    @Id
    private String id;
    @Column(name="languages")
    private String language = null;
    @Column(name="look")
    private String look = null;
    @Column(name="personalwspace")
    private String collaborativeWorkSpaceId;
    @Column(name="thesaurusstatus")
    private int thesaurusStatus;
    @Column(name="draganddropstatus")
    private int dragAndDropStatus;
    @Column(name="webdaveditingstatus")
    private int webdavEditionStatus;
    @Column(name="menuDisplay")
    private String menuDisplay = UserMenuDisplay.DEFAULT.name();

    public UserPreferences() {
    }

    public UserPreferences(String userId, String language, String look, String collaborativeWorkSpaceId, boolean thesaurusEnabled, boolean dragAndDropEnabled, boolean webdavEditionEnabled, UserMenuDisplay display) {
        this(language, look, collaborativeWorkSpaceId, thesaurusEnabled, dragAndDropEnabled, webdavEditionEnabled, display);
        this.id = userId;
    }

    public UserPreferences(String language, String look, String collaborativeWorkSpaceId, boolean thesaurusEnabled, boolean dragAndDropEnabled, boolean webdavEditionEnabled, UserMenuDisplay display) {
        this.language = language;
        this.look = look;
        this.collaborativeWorkSpaceId = collaborativeWorkSpaceId;
        this.thesaurusStatus = thesaurusEnabled ? 1 : 0;
        this.dragAndDropStatus = dragAndDropEnabled ? 1 : 0;
        this.webdavEditionStatus = webdavEditionEnabled ? 1 : 0;
        this.menuDisplay = display.name();
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public String getLanguage() {
        return this.language;
    }

    public String getLook() {
        return this.look;
    }

    public void setLook(String look) {
        if (!StringUtil.isDefined(look)) {
            this.look = "Initial";
        }
        this.look = look;
    }

    public String getCollaborativeWorkSpaceId() {
        return this.collaborativeWorkSpaceId;
    }

    public void setCollaborativeWorkSpaceId(String collaborativeWorkSpaceId) {
        this.collaborativeWorkSpaceId = collaborativeWorkSpaceId;
    }

    public String getPersonalWorkSpaceId() {
        return this.collaborativeWorkSpaceId;
    }

    public void setPersonalWorkSpaceId(String collaborativeWorkSpaceId) {
        this.collaborativeWorkSpaceId = collaborativeWorkSpaceId;
    }

    public boolean isThesaurusEnabled() {
        return 1 == this.thesaurusStatus;
    }

    public void enableThesaurus(boolean thesaurusEnabled) {
        this.thesaurusStatus = thesaurusEnabled ? 1 : 0;
    }

    public boolean isDragAndDropEnabled() {
        return 1 == this.dragAndDropStatus;
    }

    public void enableDragAndDrop(boolean dragAndDropEnabled) {
        this.dragAndDropStatus = dragAndDropEnabled ? 1 : 0;
    }

    public boolean isWebdavEditionEnabled() {
        return 1 == this.webdavEditionStatus;
    }

    public void enableWebdavEdition(boolean webdavEditionEnabled) {
        this.webdavEditionStatus = webdavEditionEnabled ? 1 : 0;
    }

    public UserMenuDisplay getDisplay() {
        if (!StringUtil.isDefined(this.menuDisplay)) {
            this.menuDisplay = UserMenuDisplay.DISABLE.name();
        }
        return UserMenuDisplay.valueOf(this.menuDisplay);
    }

    public void setDisplay(UserMenuDisplay display) {
        this.menuDisplay = display.name();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UserPreferences other = (UserPreferences)obj;
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.language == null ? other.language != null : !this.language.equals(other.language)) {
            return false;
        }
        if (this.look == null ? other.look != null : !this.look.equals(other.look)) {
            return false;
        }
        if (this.collaborativeWorkSpaceId == null ? other.collaborativeWorkSpaceId != null : !this.collaborativeWorkSpaceId.equals(other.collaborativeWorkSpaceId)) {
            return false;
        }
        if (this.thesaurusStatus != other.thesaurusStatus) {
            return false;
        }
        if (this.dragAndDropStatus != other.dragAndDropStatus) {
            return false;
        }
        if (this.webdavEditionStatus != other.webdavEditionStatus) {
            return false;
        }
        return this.getDisplay() == other.getDisplay();
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 31 * result + (this.language != null ? this.language.hashCode() : 0);
        result = 31 * result + (this.look != null ? this.look.hashCode() : 0);
        result = 31 * result + (this.collaborativeWorkSpaceId != null ? this.collaborativeWorkSpaceId.hashCode() : 0);
        result = 31 * result + this.thesaurusStatus;
        result = 31 * result + this.dragAndDropStatus;
        result = 31 * result + this.webdavEditionStatus;
        result = 31 * result + (this.menuDisplay != null ? this.menuDisplay.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "UserSettings{id=" + this.id + ", language=" + this.language + ", look=" + this.look + ", collaborativeWorkSpaceId=" + this.collaborativeWorkSpaceId + ", thesaurusStatus=" + this.isThesaurusEnabled() + ", dragDropStatus=" + this.isDragAndDropEnabled() + ", webdavEditingStatus=" + this.isWebdavEditionEnabled() + ", display=" + (Object)((Object)this.getDisplay()) + '}';
    }
}

