/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.scheduler;

import com.silverpeas.scheduler.JobExecutionContext;

public class SchedulerEvent {
    private JobExecutionContext ctx;
    private Throwable exception = null;
    private Type type;

    public static SchedulerEvent triggerFired(JobExecutionContext context) {
        return new SchedulerEvent(Type.TRIGGER_FIRED, context);
    }

    public static SchedulerEvent jobSucceeded(JobExecutionContext context) {
        return new SchedulerEvent(Type.JOB_SUCCEEDED, context);
    }

    public static SchedulerEvent jobFailed(JobExecutionContext context, Throwable throwable) {
        SchedulerEvent event = new SchedulerEvent(Type.JOB_FAILED, context);
        event.setThrowable(throwable);
        return event;
    }

    public Type getType() {
        return this.type;
    }

    public boolean isExceptionThrown() {
        return this.exception != null;
    }

    public Throwable getJobThrowable() {
        return this.exception;
    }

    public JobExecutionContext getJobExecutionContext() {
        return this.ctx;
    }

    protected SchedulerEvent(Type aType, JobExecutionContext aContext) {
        this.type = aType;
        this.ctx = aContext;
    }

    protected void setThrowable(Throwable aThrowable) {
        this.exception = aThrowable;
    }

    public static enum Type {
        TRIGGER_FIRED,
        JOB_SUCCEEDED,
        JOB_FAILED;

    }
}

