/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.scheduler.quartz;

import com.silverpeas.scheduler.quartz.QuartzSchedulerJob;
import com.silverpeas.scheduler.trigger.CronJobTrigger;
import com.silverpeas.scheduler.trigger.FixedPeriodJobTrigger;
import com.silverpeas.scheduler.trigger.JobTriggerVisitor;
import java.text.ParseException;
import java.util.Date;
import org.quartz.CronTrigger;
import org.quartz.Trigger;
import org.quartz.TriggerUtils;

public final class QuartzTriggerBuilder
implements JobTriggerVisitor {
    private Trigger quartzTrigger = null;

    public static Trigger buildFrom(QuartzSchedulerJob job) {
        QuartzTriggerBuilder visitor = new QuartzTriggerBuilder();
        job.getTrigger().accept(visitor);
        visitor.quartzTrigger.setName(job.getName());
        return visitor.quartzTrigger;
    }

    @Override
    public void visit(FixedPeriodJobTrigger trigger) {
        switch (trigger.getTimeUnit()) {
            case SECOND: {
                this.quartzTrigger = TriggerUtils.makeSecondlyTrigger((int)trigger.getTimeInterval());
                break;
            }
            case MINUTE: {
                this.quartzTrigger = TriggerUtils.makeMinutelyTrigger((int)trigger.getTimeInterval());
                break;
            }
            case HOUR: {
                this.quartzTrigger = TriggerUtils.makeHourlyTrigger((int)trigger.getTimeInterval());
            }
        }
        if (trigger.getStartDate() != null) {
            this.quartzTrigger.setStartTime(trigger.getStartDate());
        } else {
            this.quartzTrigger.setStartTime(this.quartzTrigger.getFireTimeAfter(new Date()));
        }
    }

    @Override
    public void visit(CronJobTrigger trigger) {
        try {
            CronTrigger cronTrigger = new CronTrigger();
            cronTrigger.setCronExpression("0 " + trigger.getCronExpression());
            if (trigger.getStartDate() != null) {
                cronTrigger.setStartTime(trigger.getStartDate());
            }
            this.quartzTrigger = cronTrigger;
        }
        catch (ParseException ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    private QuartzTriggerBuilder() {
    }
}

