/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.scheduler.simple;

import com.silverpeas.scheduler.Job;
import com.silverpeas.scheduler.JobExecutionContext;
import com.silverpeas.scheduler.ScheduledJob;
import com.silverpeas.scheduler.Scheduler;
import com.silverpeas.scheduler.SchedulerEvent;
import com.silverpeas.scheduler.SchedulerEventListener;
import com.silverpeas.scheduler.SchedulerException;
import com.silverpeas.scheduler.simple.SchedulerEventJob;
import com.silverpeas.scheduler.simple.SchedulerEventJobMinute;
import com.silverpeas.scheduler.simple.SchedulerJob;
import com.silverpeas.scheduler.simple.SchedulerMethodJob;
import com.silverpeas.scheduler.simple.SchedulerMethodJobMinute;
import com.silverpeas.scheduler.trigger.CronJobTrigger;
import com.silverpeas.scheduler.trigger.FixedPeriodJobTrigger;
import com.silverpeas.scheduler.trigger.JobTrigger;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

@Deprecated
public class SimpleScheduler
implements Scheduler {
    private final Map<String, SchedulerJob> jobs = new HashMap<String, SchedulerJob>();
    private ExecutorService jobSchedulingExecutor = Executors.newCachedThreadPool();

    @Override
    public boolean isJobScheduled(String jobName) {
        return this.jobs.containsKey(jobName);
    }

    private synchronized void removeJob(SchedulerJob aJob) {
        aJob.stop();
        this.jobs.remove(aJob.getJobName());
    }

    @Override
    public void unscheduleJob(String jobName) {
        if (this.jobs.containsKey(jobName)) {
            SchedulerJob job = this.jobs.get(jobName);
            this.removeJob(job);
        }
    }

    private synchronized void stopAllJobs() {
        for (SchedulerJob scheduledJob : this.jobs.values()) {
            scheduledJob.stop();
        }
        this.jobs.clear();
    }

    @Override
    public synchronized void shutdown() {
        SilverTrace.debug("scheduler", "SimpleScheduler", "-------------------- SimpleScheduler shutdown --------------------", new Exception("ForStack"));
        this.stopAllJobs();
        this.jobSchedulingExecutor.shutdown();
    }

    protected SimpleScheduler() {
        SilverTrace.debug("scheduler", "SimpleScheduler", "-------------------- SimpleScheduler started --------------------");
    }

    private synchronized ScheduledJob addJob(SchedulerJob aNewJob) throws SchedulerException {
        if (this.jobs.containsKey(aNewJob.getJobName())) {
            throw new SchedulerException("An job is already scheduled under the name '" + aNewJob.getJobName() + "'");
        }
        this.jobs.put(aNewJob.getJobName(), aNewJob);
        this.jobSchedulingExecutor.submit(aNewJob);
        return aNewJob;
    }

    @Override
    public ScheduledJob scheduleJob(String jobName, JobTrigger trigger, SchedulerEventListener listener) throws SchedulerException {
        this.checkRequiredArgs(jobName, trigger, listener);
        if (trigger instanceof FixedPeriodJobTrigger) {
            FixedPeriodJobTrigger jobTrigger = (FixedPeriodJobTrigger)trigger;
            SchedulerEventJobMinute newJob = new SchedulerEventJobMinute(this, listener, jobName, jobTrigger);
            return this.addJob(newJob);
        }
        if (trigger instanceof CronJobTrigger) {
            CronJobTrigger cronJobTrigger = (CronJobTrigger)trigger;
            SchedulerEventJob newJob = new SchedulerEventJob(this, listener, jobName);
            newJob.setSchedulingParameter(cronJobTrigger);
            return this.addJob(newJob);
        }
        throw new IllegalArgumentException("Trigger " + trigger.getClass().getName() + " not supported yet");
    }

    @Override
    public ScheduledJob scheduleJob(Job theJob, JobTrigger trigger, SchedulerEventListener listener) throws SchedulerException {
        if (theJob == null) {
            throw new IllegalArgumentException("The job is required!");
        }
        String jobName = theJob.getName();
        this.checkRequiredArgs(jobName, trigger, listener);
        if (trigger instanceof FixedPeriodJobTrigger) {
            FixedPeriodJobTrigger jobTrigger = (FixedPeriodJobTrigger)trigger;
            SchedulerMethodJobMinute newJob = new SchedulerMethodJobMinute(this, listener, jobName, jobTrigger);
            newJob.setExecutionParameter(new JobExecutor(theJob), "execute");
            return this.addJob(newJob);
        }
        if (trigger instanceof CronJobTrigger) {
            CronJobTrigger cronJobTrigger = (CronJobTrigger)trigger;
            SchedulerMethodJob newJob = new SchedulerMethodJob(this, listener, jobName);
            newJob.setSchedulingParameter(cronJobTrigger);
            newJob.setExecutionParameter(new JobExecutor(theJob), "execute");
            return this.addJob(newJob);
        }
        throw new IllegalArgumentException("Trigger " + trigger.getClass().getName() + " not supported yet");
    }

    private void checkRequiredArgs(String jobName, JobTrigger trigger, SchedulerEventListener handler) {
        if (jobName == null || jobName.isEmpty()) {
            throw new IllegalArgumentException("The job name is required!");
        }
        if (trigger == null) {
            throw new IllegalArgumentException("The job trigger is required!");
        }
        if (handler == null) {
            throw new IllegalArgumentException("The scheduling event handler is requried!");
        }
    }

    @Override
    public ScheduledJob scheduleJob(Job theJob, JobTrigger trigger) throws SchedulerException {
        return this.scheduleJob(theJob, trigger, new SchedulerEventListener(){

            @Override
            public void triggerFired(SchedulerEvent anEvent) throws Exception {
            }

            @Override
            public void jobSucceeded(SchedulerEvent anEvent) {
            }

            @Override
            public void jobFailed(SchedulerEvent anEvent) {
            }
        });
    }

    private static class JobExecutor {
        private Job job;

        public JobExecutor(Job jobToExecute) {
            this.job = jobToExecute;
        }

        public void execute(Date date) throws Exception {
            JobExecutionContext ctx = JobExecutionContext.createWith(this.job.getName(), date);
            this.job.execute(ctx);
        }
    }
}

