/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.scheduler.trigger;

import com.silverpeas.scheduler.trigger.JobTrigger;
import com.silverpeas.scheduler.trigger.JobTriggerVisitor;
import java.text.ParseException;
import org.quartz.CronExpression;

public final class CronJobTrigger
extends JobTrigger {
    private static final String CRON_SYNTAX_TO_FIX = "[0-9,/\\-\\*]+[ ]+[0-9,/\\-\\*]+[ ]+\\*[ ]+[0-9,/\\-\\*]+[ ]+\\*";
    private String cron;

    public String getCronExpression() {
        return this.cron;
    }

    protected CronJobTrigger(String cronExpression) throws ParseException {
        String[] cronExpressionParts = cronExpression.trim().split("[ ]+");
        if (cronExpressionParts[2].equals("*") && cronExpressionParts[4].matches("[0-9,/\\-,\\*]+")) {
            cronExpressionParts[2] = "?";
        } else if (cronExpressionParts[4].equals("*") && cronExpressionParts[2].matches("[0-9,/\\-]+")) {
            cronExpressionParts[4] = "?";
        }
        this.cron = cronExpressionParts[0] + " " + cronExpressionParts[1] + " " + cronExpressionParts[2] + " " + cronExpressionParts[3] + " " + cronExpressionParts[4];
        CronExpression exp = new CronExpression("* " + this.cron);
    }

    @Override
    public void accept(JobTriggerVisitor visitor) {
        visitor.visit(this);
    }
}

