/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.socialnetwork.connectors;

import com.silverpeas.socialnetwork.connectors.AbstractSocialNetworkConnector;
import com.silverpeas.socialnetwork.service.AccessToken;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.inject.Named;
import javax.servlet.http.HttpServletRequest;
import org.springframework.social.connect.UserProfile;
import org.springframework.social.linkedin.api.LinkedIn;
import org.springframework.social.linkedin.connect.LinkedInConnectionFactory;
import org.springframework.social.oauth1.AuthorizedRequestToken;
import org.springframework.social.oauth1.OAuth1Operations;
import org.springframework.social.oauth1.OAuth1Parameters;
import org.springframework.social.oauth1.OAuthToken;

@Named(value="linkedInConnector")
public class LinkedInConnector
extends AbstractSocialNetworkConnector {
    private Map<String, OAuthToken> requestTokens = new HashMap<String, OAuthToken>();
    private LinkedInConnectionFactory connectionFactory = null;
    private String consumerKey = null;
    private String secretKey = null;

    @Override
    @PostConstruct
    void init() {
        super.init();
        this.consumerKey = this.getSettings().getString("linkedIn.consumerKey");
        this.secretKey = this.getSettings().getString("linkedIn.secretKey");
        this.connectionFactory = new LinkedInConnectionFactory(this.consumerKey, this.secretKey);
    }

    @Override
    public String buildAuthenticateUrl(String callBackURL) {
        OAuth1Operations oauthOperations = this.connectionFactory.getOAuthOperations();
        OAuth1Parameters params = new OAuth1Parameters();
        OAuthToken requestToken = oauthOperations.fetchRequestToken(callBackURL, null);
        this.requestTokens.put(requestToken.getValue(), requestToken);
        return oauthOperations.buildAuthenticateUrl(requestToken.getValue(), params);
    }

    @Override
    public AccessToken exchangeForAccessToken(HttpServletRequest request, String callBackURL) {
        String authVerifier = request.getParameter("oauth_verifier");
        String oauthToken = request.getParameter("oauth_token");
        OAuth1Operations oauthOperations = this.connectionFactory.getOAuthOperations();
        OAuthToken savedToken = this.requestTokens.get(oauthToken);
        if (savedToken != null) {
            AuthorizedRequestToken authorizedRequestToken = new AuthorizedRequestToken(savedToken, authVerifier);
            OAuthToken accessToken = oauthOperations.exchangeForAccessToken(authorizedRequestToken, null);
            return new AccessToken(accessToken);
        }
        return null;
    }

    @Override
    public UserProfile getUserProfile(AccessToken authorizationToken) {
        return this.connectionFactory.createConnection(authorizationToken.getoAuthToken()).fetchUserProfile();
    }

    @Override
    public String getUserProfileId(AccessToken authorizationToken) {
        return ((LinkedIn)this.connectionFactory.createConnection(authorizationToken.getoAuthToken()).getApi()).profileOperations().getProfileId();
    }

    @Override
    public void updateStatus(AccessToken authorizationToken, String status) {
        this.connectionFactory.createConnection(authorizationToken.getoAuthToken()).updateStatus(status);
    }

    @Override
    public void setJavascriptAttributes(HttpServletRequest request) {
        request.setAttribute("LI_loadSDK", (Object)this.getSDKLoadingScript(request));
    }

    private String getSDKLoadingScript(HttpServletRequest request) {
        StringBuffer code = new StringBuffer();
        code.append("<script type=\"text/javascript\">\n");
        code.append("function onLoadLinkedIn() {\n");
        code.append("   if (initLI) { initLI() };\n");
        code.append(" };\n");
        code.append("</script>\n");
        code.append("<script type=\"text/javascript\" src=\"http://platform.linkedin.com/in.js\">\n");
        code.append("  api_key: ").append(this.consumerKey).append("\n");
        code.append("  onLoad: onLoadLinkedIn\n");
        code.append("  authorize: true\n");
        code.append("</script>\n");
        return code.toString();
    }
}

