/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.socialnetwork.relationShip;

import com.silverpeas.socialnetwork.model.SocialInformation;
import com.silverpeas.socialnetwork.relationShip.RelationShip;
import com.silverpeas.socialnetwork.relationShip.RelationShipDao;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.util.DBUtil;
import com.stratelia.webactiv.util.JNDINames;
import com.stratelia.webactiv.util.exception.UtilException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.inject.Named;

@Named
public class RelationShipService {
    private final RelationShipDao relationShipDao = new RelationShipDao();

    private Connection getConnection(boolean useAutoCommit) throws UtilException, SQLException {
        Connection connection = DBUtil.makeConnection(JNDINames.DATABASE_DATASOURCE);
        connection.setAutoCommit(useAutoCommit);
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeRelationShip(int idUser1, int idUser2) {
        Connection connection = null;
        boolean endAction = false;
        try {
            connection = this.getConnection(false);
            this.relationShipDao.deleteRelationShip(connection, idUser1, idUser2);
            this.relationShipDao.deleteRelationShip(connection, idUser2, idUser1);
            connection.commit();
            endAction = true;
        }
        catch (Exception ex) {
            SilverTrace.error("com.silverpeas.socialnetwork.relationShip", "RelationShipService.removeRelationShip", "", ex);
            DBUtil.rollback(connection);
        }
        finally {
            DBUtil.close(connection);
        }
        return endAction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInRelationShip(int user1Id, int user2Id) throws SQLException {
        Connection connection = null;
        boolean isInRelationShip = false;
        try {
            connection = this.getConnection(true);
            isInRelationShip = this.relationShipDao.isInRelationShip(connection, user1Id, user2Id);
        }
        catch (Exception ex) {
            SilverTrace.error("com.silverpeas.socialnetwork.relationShip", "RelationShipService.isInRelationShip", "", ex);
        }
        finally {
            DBUtil.close(connection);
        }
        return isInRelationShip;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<RelationShip> getAllMyRelationShips(int myId) throws SQLException {
        Connection connection = null;
        ArrayList<RelationShip> listMyRelation = new ArrayList();
        try {
            connection = this.getConnection(true);
            listMyRelation = this.relationShipDao.getAllMyRelationShips(connection, myId);
        }
        catch (Exception ex) {
            SilverTrace.error("com.silverpeas.socialnetwork.relationShip", "RelationShipService.getAllMyRelationShips", "", ex);
        }
        finally {
            DBUtil.close(connection);
        }
        return listMyRelation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getMyContactsIds(int myId) throws SQLException {
        Connection connection = null;
        ArrayList<String> myContactsIds = new ArrayList();
        try {
            connection = this.getConnection(true);
            myContactsIds = this.relationShipDao.getMyContactsIds(connection, myId);
        }
        catch (Exception ex) {
            SilverTrace.error("com.silverpeas.socialnetwork.relationShip", "RelationShipService.getMyContactsIds", "", ex);
        }
        finally {
            DBUtil.close(connection);
        }
        return myContactsIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getAllCommonContactsIds(int user1Id, int user2Id) throws SQLException {
        Connection connection = null;
        ArrayList<String> myContactsIds = new ArrayList();
        try {
            connection = this.getConnection(true);
            myContactsIds = this.relationShipDao.getAllCommonContactsIds(connection, user1Id, user2Id);
        }
        catch (Exception ex) {
            SilverTrace.error("com.silverpeas.socialnetwork.relationShip", "RelationShipService.getAllCommonContactsIds", "", ex);
        }
        finally {
            DBUtil.close(connection);
        }
        return myContactsIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SocialInformation> getAllMyRelationShips(String userId, Date begin, Date end) throws SQLException {
        Connection connection = null;
        try {
            connection = this.getConnection(true);
            List<SocialInformation> list = this.relationShipDao.getAllMyRelationShips(connection, userId, begin, end);
            return list;
        }
        catch (Exception ex) {
            SilverTrace.error("com.silverpeas.socialnetwork.relationShip", "RelationShipService.getAllMyRelationShips", "", ex);
        }
        finally {
            DBUtil.close(connection);
        }
        return new ArrayList<SocialInformation>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SocialInformation> getAllRelationShipsOfMyContact(String myId, List<String> myContactsIds, Date begin, Date end) throws SQLException {
        Connection connection = null;
        try {
            connection = this.getConnection(true);
            List<SocialInformation> list = this.relationShipDao.getAllRelationShipsOfMyContact(connection, myId, myContactsIds, begin, end);
            return list;
        }
        catch (Exception ex) {
            SilverTrace.error("com.silverpeas.socialnetwork.relationShip", "RelationShipService.getAllRelationShipsOfMyContact", "", ex);
        }
        finally {
            DBUtil.close(connection);
        }
        return new ArrayList<SocialInformation>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RelationShip getRelationShip(int user1Id, int user2Id) throws SQLException {
        Connection connection = null;
        RelationShip relation = null;
        try {
            connection = this.getConnection(true);
            relation = this.relationShipDao.getRelationShip(connection, user1Id, user2Id);
        }
        catch (Exception ex) {
            SilverTrace.error("com.silverpeas.socialnetwork.relationShip", "RelationShipService.getRelationShip", "", ex);
        }
        finally {
            DBUtil.close(connection);
        }
        return relation;
    }
}

