/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.socialnetwork.service;

import com.silverpeas.socialnetwork.connectors.SocialNetworkConnector;
import com.silverpeas.socialnetwork.dao.ExternalAccountDao;
import com.silverpeas.socialnetwork.model.AccountId;
import com.silverpeas.socialnetwork.model.ExternalAccount;
import com.silverpeas.socialnetwork.model.SocialNetworkID;
import com.silverpeas.socialnetwork.service.AccessToken;
import com.stratelia.webactiv.beans.admin.UserDetail;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.http.HttpSession;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

public class SocialNetworkService {
    private static String AUTHORIZATION_TOKEN_SESSION_ATTR = "socialnetwork_authorization_token_";
    private static String SOCIALNETWORK_ID_SESSION_ATTR = "socialnetwork_id";
    @Inject
    @Named(value="facebookConnector")
    private SocialNetworkConnector facebook = null;
    @Inject
    @Named(value="linkedInConnector")
    private SocialNetworkConnector linkedIn = null;
    @Inject
    private ExternalAccountDao dao = null;
    private static SocialNetworkService instance = null;

    public static SocialNetworkService getInstance() {
        if (instance == null) {
            instance = new SocialNetworkService();
        }
        return instance;
    }

    public SocialNetworkConnector getSocialNetworkConnector(SocialNetworkID networkId) {
        switch (networkId) {
            case FACEBOOK: {
                return this.facebook;
            }
            case LINKEDIN: {
                return this.linkedIn;
            }
        }
        return null;
    }

    public SocialNetworkConnector getSocialNetworkConnector(String networkIdAsString) {
        SocialNetworkID networkId = SocialNetworkID.valueOf(networkIdAsString);
        switch (networkId) {
            case FACEBOOK: {
                return this.facebook;
            }
            case LINKEDIN: {
                return this.linkedIn;
            }
        }
        return null;
    }

    public ExternalAccount getExternalAccount(SocialNetworkID networkId, String profileId) {
        UserDetail user;
        ExternalAccount externalAccount = (ExternalAccount)this.dao.findOne(new AccountId(networkId, profileId));
        if (externalAccount != null && ((user = UserDetail.getById(externalAccount.getSilverpeasUserId())) == null || user.isDeletedState())) {
            this.removeExternalAccount(externalAccount.getSilverpeasUserId(), networkId);
            externalAccount = null;
        }
        return externalAccount;
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public void createExternalAccount(SocialNetworkID networkId, String userId, String profileId) {
        ExternalAccount account = new ExternalAccount();
        account.setNetworkId(networkId);
        account.setSilverpeasUserId(userId);
        account.setProfileId(profileId);
        this.dao.saveAndFlush(account);
    }

    public List<ExternalAccount> getUserExternalAccounts(String userId) {
        List<ExternalAccount> accounts = this.dao.findBySilverpeasUserId(userId);
        if (accounts == null) {
            return new ArrayList<ExternalAccount>();
        }
        return accounts;
    }

    public void removeAuthorizationToken(HttpSession session) {
        SocialNetworkID networkId;
        if (session != null && (networkId = (SocialNetworkID)((Object)session.getAttribute(SOCIALNETWORK_ID_SESSION_ATTR))) != null) {
            session.setAttribute(SOCIALNETWORK_ID_SESSION_ATTR, null);
            session.setAttribute(AUTHORIZATION_TOKEN_SESSION_ATTR + (Object)((Object)networkId), null);
        }
    }

    public void storeAuthorizationToken(HttpSession session, SocialNetworkID networkId, AccessToken authorizationToken) {
        session.setAttribute(AUTHORIZATION_TOKEN_SESSION_ATTR + (Object)((Object)networkId), (Object)authorizationToken);
        session.setAttribute(SOCIALNETWORK_ID_SESSION_ATTR, (Object)networkId);
    }

    public AccessToken getStoredAuthorizationToken(HttpSession session, SocialNetworkID networkId) {
        AccessToken token = (AccessToken)session.getAttribute(AUTHORIZATION_TOKEN_SESSION_ATTR + (Object)((Object)networkId));
        return token;
    }

    public SocialNetworkID getSocialNetworkIDUsedForLogin(HttpSession session) {
        SocialNetworkID networkId = (SocialNetworkID)((Object)session.getAttribute(SOCIALNETWORK_ID_SESSION_ATTR));
        return networkId;
    }

    @Transactional
    public void removeExternalAccount(String userId, SocialNetworkID networkId) {
        List<ExternalAccount> accounts = this.dao.findBySilverpeasUserId(userId);
        if (accounts != null) {
            for (ExternalAccount account : accounts) {
                if (account.getNetworkId() != networkId) continue;
                this.dao.delete(account);
                break;
            }
        }
    }
}

