/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.thumbnail;

import com.silverpeas.admin.components.ComponentsInstanciatorIntf;
import com.silverpeas.admin.components.InstanciationException;
import com.silverpeas.thumbnail.service.ThumbnailService;
import com.silverpeas.thumbnail.service.ThumbnailServiceFactory;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.beans.admin.SQLRequest;
import com.stratelia.webactiv.util.FileRepositoryManager;
import com.stratelia.webactiv.util.fileFolder.FileFolderManager;
import java.sql.Connection;

public class ThumbnailInstanciator
extends SQLRequest
implements ComponentsInstanciatorIntf {
    public ThumbnailInstanciator() {
    }

    public ThumbnailInstanciator(String fullPathName) {
        super("com.silverpeas.thumbnail");
    }

    private ThumbnailService getThumbnailBm() {
        return ThumbnailServiceFactory.getThumbnailService();
    }

    @Override
    public void create(Connection connection, String spaceId, String componentId, String userId) throws InstanciationException {
    }

    @Override
    public void delete(Connection connection, String spaceId, String componentId, String userId) throws InstanciationException {
        SilverTrace.info("thumbnail", "ThumbnailInstanciator.delete()", "root.MSG_GEN_ENTER_METHOD", "componentId = " + componentId);
        try {
            this.getThumbnailBm().deleteAllThumbnail(componentId);
        }
        catch (Exception e) {
            throw new InstanciationException("ThumbnailInstanciator.delete()", 4, "root.EX_RECORD_DELETE_FAILED", e);
        }
        String[] ctx = new String[]{"images"};
        String path = FileRepositoryManager.getAbsolutePath(componentId, ctx);
        try {
            FileFolderManager.deleteFolder(path);
        }
        catch (Exception e) {
            throw new InstanciationException("ThumbnailInstanciator.delete()", 4, "root.DELETING_DATA_DIRECTORY_FAILED", e);
        }
        SilverTrace.info("thumbnail", "ThumbnailInstanciator.delete()", "root.MSG_GEN_EXIT_METHOD");
    }
}

