/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.util;

import com.silverpeas.admin.components.Instanciateur;
import com.silverpeas.admin.components.WAComponent;
import com.silverpeas.util.StringUtil;
import java.util.Set;

public class ComponentHelper {
    private static final ComponentHelper instance = new ComponentHelper();

    private ComponentHelper() {
    }

    public static synchronized ComponentHelper getInstance() {
        return instance;
    }

    public Set<String> listComponentTypes() {
        return Instanciateur.getWAComponents().keySet();
    }

    public String extractComponentName(String componentId) {
        if (!StringUtil.isDefined(componentId)) {
            return componentId;
        }
        StringBuilder componentName = new StringBuilder(componentId.length());
        for (int i = 0; i < componentId.length(); ++i) {
            char c = componentId.charAt(i);
            if (Character.isDigit(c)) {
                return componentName.toString();
            }
            componentName.append(c);
        }
        return componentName.toString().toLowerCase();
    }

    public WAComponent extractComponent(String componentId) {
        if (!StringUtil.isDefined(componentId)) {
            return null;
        }
        String componentName = this.extractComponentName(componentId);
        return Instanciateur.getWAComponent(componentName);
    }

    public boolean isThemeTracker(WAComponent component) {
        return this.isKmelia(component) || this.isKmax(component) || this.isToolbox(component);
    }

    public boolean isThemeTracker(String componentId) {
        return this.isThemeTracker(this.extractComponent(componentId));
    }

    public boolean isKmelia(WAComponent component) {
        if (component == null) {
            throw new IllegalArgumentException("The component must be not null");
        }
        return "kmelia".equalsIgnoreCase(component.getName());
    }

    public boolean isKmelia(String componentId) {
        return this.isKmelia(this.extractComponent(componentId));
    }

    public boolean isKmax(WAComponent component) {
        if (component == null) {
            throw new IllegalArgumentException("The component must be not null");
        }
        return "kmax".equalsIgnoreCase(component.getName());
    }

    public boolean isKmax(String componentId) {
        return this.isKmax(this.extractComponent(componentId));
    }

    public boolean isToolbox(WAComponent component) {
        if (component == null) {
            throw new IllegalArgumentException("The component must be not null");
        }
        return "toolbox".equalsIgnoreCase(component.getName());
    }

    public boolean isToolbox(String componentId) {
        return this.isToolbox(this.extractComponent(componentId));
    }
}

