/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.util.security;

import com.silverpeas.util.StringUtil;
import com.silverpeas.util.security.SilverpeasX509TrustManager;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;

public class SilverpeasSSLSocketFactory
extends SSLSocketFactory {
    public static final String TRUSTSTORE_KEY = "javax.net.ssl.trustStore";
    public static final String TRUSTSTORE_PASSWORD_KEY = "javax.net.ssl.trustStorePassword";
    private SSLSocketFactory factory;

    private char[] getTrustorePassword() {
        char[] password = new char[]{};
        if (StringUtil.isDefined(System.getProperty(TRUSTSTORE_PASSWORD_KEY))) {
            password = System.getProperty(TRUSTSTORE_PASSWORD_KEY).toCharArray();
        }
        return password;
    }

    public SilverpeasSSLSocketFactory() {
        try {
            SSLContext sslcontext = SSLContext.getInstance("TLS");
            sslcontext.init(null, new TrustManager[]{new SilverpeasX509TrustManager(System.getProperty(TRUSTSTORE_KEY), this.getTrustorePassword())}, null);
            this.factory = sslcontext.getSocketFactory();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static SocketFactory getDefault() {
        return new SilverpeasSSLSocketFactory();
    }

    @Override
    public Socket createSocket() throws IOException {
        return this.factory.createSocket();
    }

    @Override
    public Socket createSocket(Socket socket, String s, int i, boolean flag) throws IOException {
        return this.factory.createSocket(socket, s, i, flag);
    }

    @Override
    public Socket createSocket(InetAddress inaddr, int i, InetAddress inaddr1, int j) throws IOException {
        return this.factory.createSocket(inaddr, i, inaddr1, j);
    }

    @Override
    public Socket createSocket(InetAddress inaddr, int i) throws IOException {
        return this.factory.createSocket(inaddr, i);
    }

    @Override
    public Socket createSocket(String s, int i, InetAddress inaddr, int j) throws IOException {
        return this.factory.createSocket(s, i, inaddr, j);
    }

    @Override
    public Socket createSocket(String s, int i) throws IOException {
        return this.factory.createSocket(s, i);
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return this.factory.getDefaultCipherSuites();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.factory.getSupportedCipherSuites();
    }
}

