/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.util.security;

import com.stratelia.webactiv.util.ResourceLocator;
import com.stratelia.webactiv.util.exception.UtilException;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import net.sourceforge.jcetaglib.lib.X509Cert;
import org.silverpeas.authentication.encryption.UnixDESEncryption;

public class X509Factory {
    private static String truststoreFile = null;
    private static String truststorePwd = null;
    private static String p12Dir = null;
    private static String p12Salt = null;
    private static int validity = -1;
    private static String subjectDNSuffix = null;

    public static void buildP12(String userId, String login, String userLastName, String userFirstName, String domainId) throws UtilException {
        KeyPair keyPair = null;
        try {
            keyPair = X509Cert.generateKeyPair((String)"RSA", (int)1024, (byte[])new byte[0]);
        }
        catch (Exception e) {
            throw new UtilException("X509Factory.buildP12", 4, "util.CANT_GENERATE_KEYPAIR", e);
        }
        PrivateKey privateKey = keyPair.getPrivate();
        PublicKey publicKey = keyPair.getPublic();
        if (userFirstName == null) {
            userFirstName = "";
        }
        String subjectDN = subjectDNSuffix + ", CN=" + userFirstName + " " + userLastName;
        X509Certificate myCert = null;
        try {
            myCert = X509Cert.selfsign((PrivateKey)privateKey, (PublicKey)publicKey, (String)"MD5WithRSAEncryption", (long)validity, (String)subjectDN, (boolean)false, (String)"client");
        }
        catch (CertificateException e) {
            throw new UtilException("X509Factory.buildP12", 4, "util.CANT_CREATE_SELFSIGNED_X509_CERTIFICATE", (Exception)e);
        }
        KeyStore keyStore = X509Factory.getKeyStore();
        String alias = userId;
        try {
            keyStore.setCertificateEntry(alias, myCert);
        }
        catch (KeyStoreException e) {
            throw new UtilException("X509Factory.buildP12", 4, "util.CANT_STORE_X509_CERTIFICATE_INTO_TRUSTSTORE", (Exception)e);
        }
        X509Factory.writeKeyStore(keyStore);
        String p12File = p12Dir + login + "_" + domainId + ".p12";
        UnixDESEncryption desEncryption = new UnixDESEncryption();
        String password = desEncryption.encrypt(login, p12Salt.getBytes());
        try {
            X509Cert.saveAsP12((X509Certificate)myCert, null, (PrivateKey)privateKey, (String)p12File, (String)alias, (StringBuffer)new StringBuffer(password));
        }
        catch (Exception e) {
            throw new UtilException("X509Factory.buildP12", 4, "util.CANT_CREATE_PKCS12_FILE", e);
        }
    }

    public static void revocateUserCertificate(String userId) throws UtilException {
        KeyStore keyStore = X509Factory.getKeyStore();
        if (keyStore != null) {
            try {
                keyStore.deleteEntry(userId);
            }
            catch (KeyStoreException e) {
                throw new UtilException("X509Factory.revocateUserCertificate", 4, "util.CANT_DELETE_X509_CERTIFICATE_FROM_TRUSTSTORE", (Exception)e);
            }
            X509Factory.writeKeyStore(keyStore);
        }
    }

    private static KeyStore getKeyStore() throws UtilException {
        KeyStore keyStore = null;
        try {
            keyStore = KeyStore.getInstance("jks");
        }
        catch (KeyStoreException e) {
            throw new UtilException("X509Factory.getKeyStore", 4, "util.CANT_GET_KEYSTORE_INSTANCE", (Exception)e);
        }
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(truststoreFile);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        try {
            keyStore.load(fis, truststorePwd.toCharArray());
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (CertificateException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            if (fis != null) {
                fis.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return keyStore;
    }

    private static void writeKeyStore(KeyStore keyStore) {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(truststoreFile);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        try {
            keyStore.store(fos, truststorePwd.toCharArray());
        }
        catch (KeyStoreException e) {
            e.printStackTrace();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (CertificateException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            fos.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static {
        ResourceLocator settings = new ResourceLocator("com.silverpeas.util.security", "");
        truststoreFile = settings.getString("x509.TruststoreFile", "C:\\Silverpeas\\KMEdition\\Tools\\jboss403\\server\\default\\conf\\server.truststore");
        truststorePwd = settings.getString("x509.TruststorePwd", "servercert");
        String ou = settings.getString("x509.DN_OU", "silverpeas.com");
        String o = settings.getString("x509.DN_O", "Silverpeas");
        String l = settings.getString("x509.DN_L", "Grenoble");
        String c = settings.getString("x509.DN_C", "FR");
        subjectDNSuffix = "C=" + c + ", L=" + l + ", O=" + o + ", OU=" + ou;
        validity = Integer.parseInt(settings.getString("x509.Validity", "365"));
        p12Dir = settings.getString("p12.dir", "C:\\Silverpeas\\KMEdition\\Tools\\jboss403\\server\\default\\conf\\");
        p12Salt = settings.getString("p12.salt", "SP");
    }
}

