/*
 * Decompiled with CFR 0.152.
 */
package com.silverpeas.util.web.servlet;

import com.stratelia.silverpeas.silvertrace.SilverTrace;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class RestRequest {
    private String id;
    private Map<String, String[]> elements;
    private Action action;
    private HttpServletRequest request;

    public RestRequest(HttpServletRequest request, String componentId) {
        this.request = request;
        this.elements = new HashMap<String, String[]>(10);
        String pathInfo = RestRequest.getPathInfo(request, componentId);
        SilverTrace.debug("util", "RestRequest()", "root.MSG_GEN_ENTER_METHOD", "Parsing:" + pathInfo);
        String[] pathItems = pathInfo.split("/");
        if (pathItems.length > 0) {
            int itemParsingStartIndex;
            this.action = Action.fromType(pathItems[0]);
            if (this.action != null) {
                this.id = pathItems[1];
                itemParsingStartIndex = 2;
            } else {
                this.action = Action.fromType(request.getMethod());
                this.id = pathItems[0];
                itemParsingStartIndex = 1;
            }
            for (int i = itemParsingStartIndex; i < pathItems.length; ++i) {
                String key = pathItems[i++];
                if (i >= pathItems.length) continue;
                String value = pathItems[i];
                this.elements.put(key, new String[]{value});
            }
        }
        this.elements.putAll(request.getParameterMap());
    }

    public Map<String, String[]> getElements() {
        return this.elements;
    }

    public String getElementValue(String name) {
        if (this.elements.containsKey(name)) {
            return this.getElements(name)[0];
        }
        return null;
    }

    public String[] getElements(String name) {
        return this.elements.get(name);
    }

    public Action getAction() {
        return this.action;
    }

    public String getId() {
        return this.id;
    }

    public HttpServletRequest getWebRequest() {
        return this.request;
    }

    private static String getPathInfo(HttpServletRequest request, String componentId) {
        int routingIndex;
        String pathInfo = request.getRequestURI();
        String context = request.getContextPath();
        int startIndex = pathInfo.indexOf(context) + context.length();
        pathInfo = pathInfo.substring(startIndex);
        if (componentId != null && (routingIndex = pathInfo.indexOf(componentId)) >= 0) {
            pathInfo = pathInfo.substring(routingIndex + componentId.length());
        }
        if (pathInfo.startsWith("/")) {
            pathInfo = pathInfo.substring(1);
        }
        return pathInfo;
    }

    public static enum Action {
        UPDATE("put"),
        DELETE("delete"),
        FIND("get"),
        CREATE("post");

        private final String type;

        private Action(String type) {
            this.type = type;
        }

        public String type() {
            return this.type;
        }

        public static Action fromType(String actionType) {
            if (actionType.equalsIgnoreCase(UPDATE.type())) {
                return UPDATE;
            }
            if (actionType.equalsIgnoreCase(DELETE.type())) {
                return DELETE;
            }
            if (actionType.equalsIgnoreCase(FIND.type())) {
                return FIND;
            }
            if (actionType.equalsIgnoreCase(CREATE.type())) {
                return CREATE;
            }
            return null;
        }
    }
}

