/*
 * Decompiled with CFR 0.152.
 */
package com.stratelia.silverpeas.domains.ldapdriver;

import com.novell.ldap.LDAPEntry;
import com.stratelia.silverpeas.domains.ldapdriver.AbstractLDAPTimeStamp;
import com.stratelia.silverpeas.domains.ldapdriver.LDAPSettings;
import com.stratelia.silverpeas.domains.ldapdriver.LDAPSynchroCache;
import com.stratelia.silverpeas.domains.ldapdriver.LDAPUtility;
import com.stratelia.silverpeas.silvertrace.SilverTrace;
import com.stratelia.webactiv.beans.admin.AdminException;
import com.stratelia.webactiv.beans.admin.Group;
import com.stratelia.webactiv.beans.admin.SynchroReport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public abstract class AbstractLDAPGroup {
    LDAPSettings driverSettings = null;
    LDAPSynchroCache synchroCache = null;
    private StringBuffer synchroReport = null;
    boolean synchroInProcess = false;

    public void init(LDAPSettings driverSettings, LDAPSynchroCache synchroCache) {
        this.driverSettings = driverSettings;
        this.synchroCache = synchroCache;
    }

    AbstractLDAPGroup append(CharSequence message) {
        this.synchroReport.append(message);
        return this;
    }

    public void beginSynchronization() throws Exception {
        this.synchroReport = new StringBuffer();
        this.synchroInProcess = true;
    }

    public String endSynchronization() throws Exception {
        this.synchroInProcess = false;
        return this.synchroReport.toString();
    }

    public Group[] getAllChangedGroups(String lds, String extraFilter) throws AdminException {
        return this.getAllGroups(lds, extraFilter);
    }

    public Group[] getAllGroups(String lds, String extraFilter) throws AdminException {
        HashMap<String, Group> groupsDone = new HashMap<String, Group>();
        ArrayList<Group> groupsCurrent = new ArrayList<Group>();
        Group[] groupsVector = this.getGroups(lds, null, extraFilter);
        groupsCurrent.addAll(Arrays.asList(groupsVector));
        while (groupsCurrent.size() > 0) {
            Group group = (Group)groupsCurrent.remove(groupsCurrent.size() - 1);
            String groupId = group.getSpecificId();
            if (groupsDone.get(groupId) != null) continue;
            groupsDone.put(groupId, group);
            groupsVector = this.getGroups(lds, groupId, extraFilter);
            groupsCurrent.addAll(Arrays.asList(groupsVector));
        }
        return groupsDone.values().toArray(new Group[groupsDone.size()]);
    }

    public Group[] getGroups(String lds, String parentId, String extraFilter) throws AdminException {
        ArrayList<Group> groupsReturned = new ArrayList<Group>();
        ArrayList<LDAPEntry> groupMerged = new ArrayList<LDAPEntry>();
        if (parentId == null) {
            SynchroReport.info("AbstractLDAPGroup.getGroups()", "Recherche des groupes racine du domaine LDAP distant...", null);
        } else {
            SynchroReport.info("AbstractLDAPGroup.getGroups()", "Recherche des groupes fils inclus au groupe " + parentId + " du domaine LDAP distant...", null);
        }
        LDAPEntry[] groupsFounded = this.getChildGroupsEntry(lds, parentId, extraFilter);
        SynchroReport.info("AbstractLDAPGroup.getGroups()", "groupsFounded=" + groupsFounded.length, null);
        Group[] groupsProcessed = new Group[groupsFounded.length];
        for (int i = 0; i < groupsFounded.length; ++i) {
            int cpt = i;
            boolean groupSplitted = false;
            if (i + 1 < groupsFounded.length) {
                String firstGroupSplitted = groupsFounded[i].getDN();
                while (i + 1 < groupsFounded.length && firstGroupSplitted.equals(groupsFounded[++cpt].getDN())) {
                    groupSplitted = true;
                    groupMerged.add(groupsFounded[cpt - 1]);
                    ++i;
                }
            }
            if (groupSplitted) {
                groupMerged.add(groupsFounded[cpt - 1]);
                groupsProcessed[i] = this.translateGroups(lds, groupMerged);
                groupMerged.clear();
            } else {
                groupsProcessed[i] = this.translateGroup(lds, groupsFounded[i]);
            }
            groupsReturned.add(groupsProcessed[i]);
            if (groupsProcessed[i] != null) {
                SynchroReport.warn("AbstractLDAPGroup.getGroups()", "groupsReturned[i]" + groupsProcessed[i].getId() + " - " + groupsProcessed[i].getName(), null);
            }
            String StrTypeGroup = parentId == null ? "Groupe racine" : "Groupe fils";
            if (groupsProcessed[i].getUserIds().length != 0) {
                SynchroReport.debug("AbstractLDAPGroup.getGroups()", StrTypeGroup + " trouv\u00e9 no : " + Integer.toString(i) + ", nom du groupe : " + groupsProcessed[i].getSpecificId() + ", desc. : " + groupsProcessed[i].getDescription() + ". " + groupsProcessed[i].getUserIds().length + " utilisateur(s) membre(s) associ\u00e9(s)", null);
            } else {
                SynchroReport.debug("AbstractLDAPGroup.getGroups()", StrTypeGroup + " trouv\u00e9 no : " + Integer.toString(i) + ", nom du groupe : " + groupsProcessed[i].getSpecificId() + ", desc. : " + groupsProcessed[i].getDescription(), null);
            }
            SilverTrace.info("admin", "AbstractLDAPGroup.getGroups()", "root.MSG_GEN_PARAM_VALUE", "Group " + Integer.toString(i) + " : " + groupsProcessed[i].getName() + " Parent = " + parentId);
            groupsProcessed[i].traceGroup();
        }
        if (parentId == null) {
            SynchroReport.info("AbstractLDAPGroup.getGroups()", "R\u00e9cup\u00e9ration de " + groupsFounded.length + " groupes racine du domaine LDAP distant", null);
        } else {
            SynchroReport.info("AbstractLDAPGroup.getGroups()", "R\u00e9cup\u00e9ration de " + groupsFounded.length + " groupes fils du groupe " + parentId, null);
        }
        return groupsReturned.toArray(new Group[groupsReturned.size()]);
    }

    public Group getGroup(String lds, String id) throws AdminException {
        LDAPEntry theEntry = null;
        try {
            theEntry = this.getGroupEntry(lds, id);
        }
        catch (AdminException e) {
            if (this.synchroInProcess) {
                SilverTrace.warn("admin", "AbstractLDAPGroup.getGroup", "admin.EX_ERR_GET_GROUP", "GroupId=" + id, e);
                this.synchroReport.append("PB getting Group : ").append(id).append("\n");
            }
            throw e;
        }
        return this.translateGroup(lds, theEntry);
    }

    public Group getGroupByName(String lds, String name) throws AdminException {
        LDAPEntry theEntry = null;
        try {
            theEntry = this.getGroupEntryByName(lds, name);
        }
        catch (AdminException e) {
            if (this.synchroInProcess) {
                SilverTrace.warn("admin", "AbstractLDAPGroup.getGroupByName", "admin.EX_ERR_GET_GROUP", "GroupId=" + name, e);
                this.synchroReport.append("PB getting Group : ").append(name).append("\n");
            }
            throw e;
        }
        return this.translateGroup(lds, theEntry);
    }

    public AbstractLDAPTimeStamp getMaxTimeStamp(String lds, String minTimeStamp) throws AdminException {
        AbstractLDAPTimeStamp theTimeStamp = this.driverSettings.newLDAPTimeStamp(minTimeStamp);
        theTimeStamp.initFromServer(lds, this.driverSettings.getGroupsSpecificGroupsBaseDN(), this.driverSettings.getGroupsFullFilter(), this.driverSettings.getGroupsNameField());
        return theTimeStamp;
    }

    protected Group translateGroup(String lds, LDAPEntry groupEntry) throws AdminException {
        Group groupInfos = new Group();
        if (groupEntry == null) {
            throw new AdminException("AbstractLDAPGroup.translateGroup", 4, "admin.EX_ERR_LDAP_GROUP_ENTRY_ISNULL");
        }
        groupInfos.setSpecificId(LDAPUtility.getFirstAttributeValue(groupEntry, this.driverSettings.getGroupsIdField()));
        groupInfos.setName(LDAPUtility.getFirstAttributeValue(groupEntry, this.driverSettings.getGroupsNameField()));
        groupInfos.setDescription(LDAPUtility.getFirstAttributeValue(groupEntry, this.driverSettings.getGroupsDescriptionField()));
        try {
            groupInfos.setUserIds(this.getUserIds(lds, groupEntry));
        }
        catch (AdminException e) {
            if (this.synchroInProcess) {
                SilverTrace.warn("admin", "AbstractLDAPGroup.translateGroup", "admin.EX_ERR_CHILD_USERS", "Group=" + groupInfos.getName(), e);
                this.synchroReport.append("PB getting Group's childs : ").append(groupInfos.getName()).append("\n");
                SynchroReport.error("AbstractLDAPGroup.translateGroup()", "Pb de r\u00e9cup\u00e9ration des membres utilisateurs du groupe " + groupInfos.getSpecificId(), e);
            }
            throw e;
        }
        return groupInfos;
    }

    protected Group translateGroups(String lds, List<LDAPEntry> groupEntries) throws AdminException {
        Group groupInfos = new Group();
        ArrayList allUserIds = new ArrayList();
        if (groupEntries.isEmpty()) {
            throw new AdminException("AbstractLDAPGroup.translateGroups", 4, "admin.EX_ERR_LDAP_GROUP_ENTRY_ISNULL");
        }
        boolean first = true;
        for (LDAPEntry groupEntry : groupEntries) {
            if (first) {
                groupInfos.setSpecificId(LDAPUtility.getFirstAttributeValue(groupEntry, this.driverSettings.getGroupsIdField()));
                groupInfos.setName(LDAPUtility.getFirstAttributeValue(groupEntry, this.driverSettings.getGroupsNameField()));
                groupInfos.setDescription(LDAPUtility.getFirstAttributeValue(groupEntry, this.driverSettings.getGroupsDescriptionField()));
                first = false;
            }
            try {
                String[] userIds = this.getUserIds(lds, groupEntry);
                SynchroReport.warn("AbstractLDAPGroup.translateGroups()", "Users in group: " + userIds.length, null);
                Collections.addAll(allUserIds, userIds);
            }
            catch (AdminException e) {
                if (this.synchroInProcess) {
                    SilverTrace.warn("admin", "AbstractLDAPGroup.translateGroups", "admin.EX_ERR_CHILD_USERS", "Group=" + groupInfos.getName(), e);
                    this.synchroReport.append("PB getting Group's childs : ").append(groupInfos.getName()).append("\n");
                    SynchroReport.error("AbstractLDAPGroup.translateGroups()", "Pb de r\u00e9cup\u00e9ration des membres utilisateurs du groupe " + groupInfos.getSpecificId(), e);
                    continue;
                }
                throw e;
            }
        }
        groupInfos.setUserIds(allUserIds.toArray(new String[allUserIds.size()]));
        SynchroReport.warn("AbstractLDAPGroup.translateGroups()", "Users in merged Group: " + groupInfos.getNbUsers(), null);
        return groupInfos;
    }

    public abstract String[] getGroupMemberGroupIds(String var1, String var2) throws AdminException;

    public abstract String[] getUserMemberGroupIds(String var1, String var2) throws AdminException;

    protected abstract String[] getUserIds(String var1, LDAPEntry var2) throws AdminException;

    protected abstract LDAPEntry[] getChildGroupsEntry(String var1, String var2, String var3) throws AdminException;

    protected LDAPEntry getGroupEntry(String lds, String groupId) throws AdminException {
        SilverTrace.info("admin", "AbstractLDAPGroup.getGroupEntry()", "root.MSG_GEN_ENTER_METHOD", "groupId=" + groupId);
        return LDAPUtility.getFirstEntryFromSearch(lds, this.driverSettings.getGroupsSpecificGroupsBaseDN(), this.driverSettings.getScope(), this.driverSettings.getGroupsIdFilter(groupId), this.driverSettings.getGroupAttributes());
    }

    protected LDAPEntry getGroupEntryByName(String lds, String groupName) throws AdminException {
        SilverTrace.info("admin", "AbstractLDAPGroup.getGroupEntryByName()", "root.MSG_GEN_ENTER_METHOD", "groupName=" + groupName);
        return LDAPUtility.getFirstEntryFromSearch(lds, this.driverSettings.getGroupsSpecificGroupsBaseDN(), this.driverSettings.getScope(), this.driverSettings.getGroupsNameFilter(groupName), this.driverSettings.getGroupAttributes());
    }
}

